/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.service.swagger;

import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.causeway.applib.services.swagger.Format;
import org.apache.causeway.applib.services.swagger.SwaggerService;
import org.apache.causeway.applib.services.swagger.Visibility;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.core.config.RestEasyConfiguration;
import org.apache.causeway.core.config.viewer.web.WebAppContextPath;
import org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal.OpenApiSpecGenerator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.viewer.ro.swaggerServiceDefault")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class SwaggerServiceDefault
implements SwaggerService {
    private final OpenApiSpecGenerator swaggerSpecGenerator;
    private final String basePath;

    @Inject
    public SwaggerServiceDefault(OpenApiSpecGenerator swaggerSpecGenerator, RestEasyConfiguration restEasyConfiguration, WebAppContextPath webAppContextPath) {
        this.swaggerSpecGenerator = swaggerSpecGenerator;
        String restfulPath = restEasyConfiguration.getJaxrs().getDefaultPath();
        String restfulBase = webAppContextPath.prependContextPath(restfulPath);
        this.basePath = _Strings.suffix((String)restfulBase, (String)"/");
    }

    public String generateSwaggerSpec(Visibility visibility, Format format) {
        return this.swaggerSpecGenerator.generate(this.basePath, visibility, format);
    }
}

