/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal.Tagger;
import org.springframework.stereotype.Component;

@Component
@Named(value="causeway.viewer.ro.TaggerDefault")
public class TaggerDefault
implements Tagger {
    static Pattern tagPatternForFqcn = Pattern.compile("^.*\\.([^\\.]+)\\.([^\\.]+)$");
    static Pattern tagPatternForTwoParts = Pattern.compile("^([^\\.]+)\\.([^\\.]+)$");
    static Pattern tagPatternForJaxbDto = Pattern.compile("^.*\\.([^\\.]+)\\.(v[0-9][^\\.]*)\\.([^\\.]+)$");

    @Override
    @Programmatic
    public String tagForLogicalTypeName(String logicalTypeName, String fallback) {
        if (logicalTypeName.startsWith("org.apache.causeway.")) {
            return "\u2026 asf causeway internals";
        }
        if (logicalTypeName.startsWith("causeway.applib")) {
            return "\u2026 asf causeway applib";
        }
        if (logicalTypeName.startsWith("causeway.conf") || logicalTypeName.startsWith("causeway.config")) {
            return "\u2026 asf causeway config";
        }
        if (logicalTypeName.startsWith("causeway.feat")) {
            return "\u2026 asf causeway feat";
        }
        if (logicalTypeName.startsWith("causeway.schema")) {
            return "\u2026 asf causeway schema";
        }
        if (logicalTypeName.startsWith("causeway.sudo")) {
            return "\u2026 asf causeway sudo";
        }
        if (logicalTypeName.startsWith("causeway.metamodel")) {
            return "\u2026 asf causeway metamodel";
        }
        if (logicalTypeName.startsWith("causeway.runtime") || logicalTypeName.startsWith("causeway.runtimeservices") || logicalTypeName.startsWith("causeway.interaction") || logicalTypeName.startsWith("causeway.transaction") || logicalTypeName.startsWith("causeway.webapp")) {
            return "\u2026 asf causeway runtime";
        }
        if (logicalTypeName.startsWith("causeway.viewer.ro") || logicalTypeName.startsWith("causeway.viewer.roRendering")) {
            return "\u2026 asf causeway viewer (restful)";
        }
        if (logicalTypeName.startsWith("causeway.viewer.wicket")) {
            return "\u2026 asf causeway viewer (wicket)";
        }
        if (logicalTypeName.startsWith("causeway.viewer.")) {
            return "\u2026 asf causeway viewer";
        }
        if (logicalTypeName.startsWith("causeway.persistence.")) {
            return "\u2026 asf causeway persistence - " + TaggerDefault.partsOf(logicalTypeName).skip(2L).limit(1L).collect(Collectors.joining("."));
        }
        if (logicalTypeName.startsWith("causeway.security.")) {
            return "\u2026 asf causeway security";
        }
        if (logicalTypeName.startsWith("causeway.testing")) {
            return "\u2026 asf causeway testing";
        }
        if (logicalTypeName.startsWith("causeway.ext.")) {
            return "\u2026 asf causeway extensions - " + TaggerDefault.partsOf(logicalTypeName).skip(2L).limit(1L).collect(Collectors.joining("."));
        }
        if (logicalTypeName.startsWith("org.springframework.")) {
            return "\u2026 spring framework " + TaggerDefault.partsOf(logicalTypeName).skip(2L).limit(1L).collect(Collectors.joining("."));
        }
        Matcher matcher = tagPatternForJaxbDto.matcher(logicalTypeName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        matcher = tagPatternForFqcn.matcher(logicalTypeName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        matcher = tagPatternForTwoParts.matcher(logicalTypeName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return fallback != null ? fallback : logicalTypeName;
    }

    private static Stream<String> partsOf(String logicalTypeName) {
        return _Strings.splitThenStream((String)logicalTypeName, (String)".");
    }
}

