/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._Bytes;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.causeway.viewer.restfulobjects.applib.util.JsonMapper;
import org.apache.causeway.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.springframework.lang.Nullable;

public final class RequestParams {
    @NonNull
    private final Nature nature;
    @Nullable
    private final String raw;

    public static RequestParams ofRequestBody(InputStream is) {
        return RequestParams.of(Nature.REQUEST_BODY, RequestParams.asStringUtf8(is));
    }

    public static RequestParams ofQueryString(String queryString) {
        return RequestParams.of(Nature.QUERY_STRING, queryString);
    }

    public static RequestParams ofEmptyQueryString() {
        return RequestParams.of(Nature.QUERY_STRING, "");
    }

    public JsonRepresentation asMap() {
        return RequestParams.readAsMap(this.raw, this.nature.name());
    }

    private static String asStringUtf8(InputStream body) {
        try {
            return _Strings.ofBytes((byte[])_Bytes.of((InputStream)body), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw RestfulObjectsApplicationException.createWithCauseAndMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, e, "could not read body", new Object[0]);
        }
    }

    private static JsonRepresentation readAsMap(String rawArgs, String argsNature) {
        if (rawArgs == null) {
            return JsonRepresentation.newMap((String[])new String[0]);
        }
        String bodyTrimmed = rawArgs.trim();
        if (bodyTrimmed.isEmpty()) {
            return JsonRepresentation.newMap((String[])new String[0]);
        }
        try {
            JsonRepresentation jsonRepr = JsonMapper.instance().read(rawArgs);
            if (!jsonRepr.isMap()) {
                throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, "could not read %s as a JSON map", argsNature);
            }
            return jsonRepr;
        }
        catch (JsonParseException e) {
            throw RestfulObjectsApplicationException.createWithCauseAndMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, (Exception)((Object)e), "could not parse %s", argsNature);
        }
        catch (JsonMappingException e) {
            throw RestfulObjectsApplicationException.createWithCauseAndMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, (Exception)((Object)e), "could not read %s as JSON", argsNature);
        }
        catch (IOException e) {
            throw RestfulObjectsApplicationException.createWithCauseAndMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, e, "could not parse %s", argsNature);
        }
    }

    @Generated
    private RequestParams(@NonNull Nature nature, @Nullable String raw) {
        if (nature == null) {
            throw new NullPointerException("nature is marked non-null but is null");
        }
        this.nature = nature;
        this.raw = raw;
    }

    @Generated
    public static RequestParams of(@NonNull Nature nature, @Nullable String raw) {
        if (nature == null) {
            throw new NullPointerException("nature is marked non-null but is null");
        }
        return new RequestParams(nature, raw);
    }

    @NonNull
    @Generated
    public Nature nature() {
        return this.nature;
    }

    @Nullable
    @Generated
    public String raw() {
        return this.raw;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestParams)) {
            return false;
        }
        RequestParams other = (RequestParams)o;
        Nature this$nature = this.nature();
        Nature other$nature = other.nature();
        if (this$nature == null ? other$nature != null : !((Object)((Object)this$nature)).equals((Object)other$nature)) {
            return false;
        }
        String this$raw = this.raw();
        String other$raw = other.raw();
        return !(this$raw == null ? other$raw != null : !this$raw.equals(other$raw));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Nature $nature = this.nature();
        result = result * 59 + ($nature == null ? 43 : ((Object)((Object)$nature)).hashCode());
        String $raw = this.raw();
        result = result * 59 + ($raw == null ? 43 : $raw.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RequestParams(nature=" + this.nature() + ", raw=" + this.raw() + ")";
    }

    static enum Nature {
        REQUEST_BODY,
        QUERY_STRING;

    }
}

