/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.domainobjects;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import lombok.NonNull;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.core.metamodel.consent.Consent;
import org.apache.causeway.core.metamodel.facetapi.Facet;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedMember;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.Rel;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.causeway.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.DomainObjectLinkTo;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.MemberType;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.MutatorSpec;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;

public abstract class AbstractObjectMemberReprRenderer<T extends ObjectMember>
extends ReprRendererAbstract<ManagedMember> {
    protected ObjectAdapterLinkTo linkTo;
    protected ManagedObject objectAdapter;
    protected Mode mode = Mode.INLINE;
    protected MemberType objectMemberType;
    protected T objectMember;
    private String memberId;
    protected final Where where;

    public AbstractObjectMemberReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollower, String memberId, RepresentationType representationType, JsonRepresentation representation, Where where) {
        super(resourceContext, linkFollower, representationType, representation);
        this.memberId = memberId;
        this.where = where;
    }

    protected String getMemberId() {
        return this.memberId;
    }

    @Override
    public AbstractObjectMemberReprRenderer<T> with(ManagedMember objectAndMember) {
        this.objectAdapter = objectAndMember.getOwner();
        this.objectMember = (ObjectMember)_Casts.uncheckedCast((Object)objectAndMember.getMetaModel());
        this.objectMemberType = MemberType.determineFrom(this.objectMember);
        this.memberId = this.objectMember.getId();
        this.usingLinkTo(new DomainObjectLinkTo());
        return this;
    }

    public AbstractObjectMemberReprRenderer<T> usingLinkTo(ObjectAdapterLinkTo linkTo) {
        this.linkTo = linkTo.usingUrlBase(this.resourceContext).with(this.objectAdapter);
        return this;
    }

    public AbstractObjectMemberReprRenderer<T> asStandalone() {
        this.mode = Mode.STANDALONE;
        return this;
    }

    public AbstractObjectMemberReprRenderer<T> asEventSerialization() {
        this.mode = Mode.EVENT_SERIALIZATION;
        return this;
    }

    public AbstractObjectMemberReprRenderer<T> asFollowed() {
        this.mode = Mode.FOLLOWED;
        return this;
    }

    public AbstractObjectMemberReprRenderer<T> asMutated() {
        this.mode = Mode.MUTATED;
        return this;
    }

    public AbstractObjectMemberReprRenderer<T> asArguments() {
        this.mode = Mode.ARGUMENTS;
        return this;
    }

    protected void renderMemberContent() {
        if (!this.resourceContext.config().isSuppressMemberId()) {
            this.representation.mapPutString("id", this.objectMember.getId());
        }
        if (!this.mode.isArguments()) {
            this.representation.mapPutString("memberType", this.objectMemberType.getName());
        }
        if (this.mode.isInline() && !this.resourceContext.config().isSuppressMemberLinks()) {
            this.addDetailsLinkIfPersistent();
        }
        if (this.mode.isStandalone()) {
            this.addLinkToSelf();
        }
        if (this.mode.isStandalone() || this.mode.isMutated()) {
            this.addLinkToUp();
        }
        if (this.mode.isFollowed() || this.mode.isStandalone() || this.mode.isMutated()) {
            this.addMutatorLinksIfEnabled();
            if (!this.mode.isInline() || !this.resourceContext.config().isSuppressUpdateLink()) {
                this.putExtensionsCausewayProprietary();
            }
            this.addLinksToFormalDomainModel();
        }
    }

    public void withMemberMode(ManagedMember.RepresentationMode memberMode) {
        if (memberMode.isWrite()) {
            this.asMutated();
        } else {
            this.asStandalone();
        }
    }

    private void addLinkToSelf() {
        this.getLinks().arrayAdd(this.linkTo.memberBuilder(Rel.SELF, this.objectMemberType, (ObjectMember)this.objectMember, new String[0]).build());
    }

    private void addLinkToUp() {
        this.getLinks().arrayAdd(this.linkTo.builder(Rel.UP).build());
    }

    protected abstract void addMutatorLinksIfEnabled();

    protected void addLinkFor(@NonNull MutatorSpec mutatorSpec) {
        if (mutatorSpec == null) {
            throw new NullPointerException("mutatorSpec is marked non-null but is null");
        }
        if (!mutatorSpec.appliesTo((ObjectMember)this.objectMember)) {
            return;
        }
        JsonRepresentation arguments = this.mutatorArgs(mutatorSpec);
        RepresentationType representationType = this.objectMemberType.getRepresentationType();
        JsonRepresentation mutatorLink = this.linkToForMutatorInvoke().memberBuilder(mutatorSpec.rel, this.objectMemberType, (ObjectMember)this.objectMember, representationType, mutatorSpec.suffix).withHttpMethod(mutatorSpec.httpMethod).withArguments(arguments).build();
        this.getLinks().arrayAdd(mutatorLink);
    }

    protected ObjectAdapterLinkTo linkToForMutatorInvoke() {
        return this.linkTo;
    }

    protected JsonRepresentation mutatorArgs(MutatorSpec mutatorSpec) {
        if (mutatorSpec.arguments.isNone()) {
            return null;
        }
        if (mutatorSpec.arguments.isOne()) {
            JsonRepresentation repr = JsonRepresentation.newMap((String[])new String[0]);
            repr.mapPutJsonNode("value", (JsonNode)NullNode.getInstance());
            return repr;
        }
        throw new UnsupportedOperationException("override mutatorArgs() to populate for many arguments");
    }

    private void addDetailsLinkIfPersistent() {
        if (!ManagedObjects.isIdentifiable((ManagedObject)this.objectAdapter)) {
            return;
        }
        JsonRepresentation link = this.linkTo.memberBuilder(Rel.DETAILS, this.objectMemberType, (ObjectMember)this.objectMember, new String[0]).build();
        this.getLinks().arrayAdd(link);
        LinkFollowSpecs membersLinkFollower = this.getLinkFollowSpecs();
        LinkFollowSpecs detailsLinkFollower = membersLinkFollower.follow("links", new Object[0]);
        JsonRepresentation memberMap = JsonRepresentation.newMap((String[])new String[0]);
        memberMap.mapPutJsonRepresentation(this.getMemberId(), this.representation);
        if (membersLinkFollower.matches(memberMap) && detailsLinkFollower.matches(link)) {
            this.followDetailsLink(link);
        }
    }

    protected abstract void followDetailsLink(JsonRepresentation var1);

    protected final void putDisabledReasonIfDisabled() {
        if (this.resourceContext.config().isSuppressMemberDisabledReason()) {
            return;
        }
        String disabledReasonRep = this.usability().getReasonAsString().orElse(null);
        this.representation.mapPutString("disabledReason", disabledReasonRep);
    }

    protected abstract void putExtensionsCausewayProprietary();

    protected abstract void addLinksToFormalDomainModel();

    public boolean isMemberVisible() {
        return this.visibility().isAllowed();
    }

    protected <F extends Facet> F getMemberSpecFacet(Class<F> facetType) {
        return (F)this.objectMember.getElementType().getFacet(facetType);
    }

    protected Consent usability() {
        return this.objectMember.isUsable(this.objectAdapter, this.getInteractionInitiatedBy(), this.where);
    }

    protected Consent visibility() {
        return this.objectMember.isVisible(this.objectAdapter, this.getInteractionInitiatedBy(), this.where);
    }

    protected static enum Mode {
        INLINE,
        FOLLOWED,
        STANDALONE,
        MUTATED,
        ARGUMENTS,
        EVENT_SERIALIZATION;


        public boolean isInline() {
            return this == INLINE;
        }

        public boolean isFollowed() {
            return this == FOLLOWED;
        }

        public boolean isStandalone() {
            return this == STANDALONE;
        }

        public boolean isMutated() {
            return this == MUTATED;
        }

        public boolean isArguments() {
            return this == ARGUMENTS;
        }

        public boolean isEventSerialization() {
            return this == EVENT_SERIALIZATION;
        }
    }
}

