/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.domainobjects;

import jakarta.ws.rs.core.MediaType;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.HasObjectFeature;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.Rel;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.causeway.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.causeway.viewer.restfulobjects.rendering.ReprRendererException;
import org.apache.causeway.viewer.restfulobjects.rendering.service.valuerender.JsonValueConverter;

public class ScalarValueReprRenderer
extends ReprRendererAbstract<ManagedObject>
implements HasObjectFeature {
    private ObjectSpecification returnType;
    private ObjectFeature objectFeature;

    public ScalarValueReprRenderer(IResourceContext resourceContext, ObjectFeature objectFeature, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, null, representation);
        this.objectFeature = objectFeature;
    }

    @Override
    public MediaType getMediaType() {
        throw new UnsupportedOperationException("no mediaType defined for scalar values");
    }

    public ScalarValueReprRenderer with(ManagedObject objectAdapter) {
        if (!objectAdapter.getSpecification().isValue()) {
            throw ReprRendererException.create("Not an (encodable) value", objectAdapter.getTitle());
        }
        JsonValueConverter.Context context = JsonValueConverter.Context.of(this.getObjectFeature(), this.getResourceContext().config().isSuppressMemberExtensions());
        Object value = this.jsonValueEncoder.asObject(objectAdapter, context);
        this.representation.mapPut("value", value);
        return this;
    }

    @Override
    public JsonRepresentation render() {
        this.addLinkToReturnType();
        this.getExtensions();
        return this.representation;
    }

    public ScalarValueReprRenderer withReturnType(ObjectSpecification returnType) {
        this.returnType = returnType;
        return this;
    }

    private void addLinkToReturnType() {
        this.addLink(Rel.RETURN_TYPE, this.returnType);
    }

    public ObjectFeature getObjectFeature() {
        return this.objectFeature;
    }
}

