/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.service.conneg;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.apache.causeway.applib.domain.DomainObjectList;
import org.apache.causeway.applib.services.i18n.TranslationService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedCollection;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedMember;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedProperty;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.MmTitleUtils;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.causeway.viewer.restfulobjects.rendering.Caching;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.Responses;
import org.apache.causeway.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.AbstractObjectMemberReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ActionResultReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ObjectActionReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ObjectCollectionReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ObjectPropertyReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.causeway.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.viewer.ro.ContentNegotiationServiceForRestfulObjectsV1_0")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="RestfulObjectsV1_0")
public class ContentNegotiationServiceForRestfulObjectsV1_0
implements ContentNegotiationService {
    protected final CausewayConfiguration configuration;
    protected final SpecificationLoader specificationLoader;
    private final AcceptChecking acceptChecking;

    @Inject
    public ContentNegotiationServiceForRestfulObjectsV1_0(CausewayConfiguration configuration, SpecificationLoader specificationLoader) {
        this.configuration = configuration;
        this.specificationLoader = specificationLoader;
        this.acceptChecking = AcceptChecking.fromConfig(configuration);
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedObject objectAdapter) {
        this.ensureCompatibleAcceptHeader(RepresentationType.DOMAIN_OBJECT, resourceContext);
        return this.responseBuilder(this.buildResponseTo(resourceContext, objectAdapter, JsonRepresentation.newMap((String[])new String[0]), null));
    }

    Response.ResponseBuilder buildResponseTo(IResourceContext resourceContext, ManagedObject objectAdapter, JsonRepresentation representationIfAnyRequired, JsonRepresentation rootRepresentation) {
        DomainObjectReprRenderer renderer = (DomainObjectReprRenderer)new DomainObjectReprRenderer(resourceContext, null, representationIfAnyRequired).with(objectAdapter).includesSelf();
        Response.ResponseBuilder responseBuilder = Responses.ofOk(renderer, Caching.NONE, rootRepresentation);
        if (resourceContext.getIntent() == RepresentationService.Intent.JUST_CREATED) {
            responseBuilder.status(Response.Status.CREATED);
        }
        return responseBuilder;
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedProperty objectAndProperty) {
        this.ensureCompatibleAcceptHeader(RepresentationType.OBJECT_PROPERTY, resourceContext);
        AbstractObjectMemberReprRenderer renderer = new ObjectPropertyReprRenderer(resourceContext).with((ManagedMember)objectAndProperty).usingLinkTo(resourceContext.getObjectAdapterLinkTo());
        ManagedMember.RepresentationMode repMode = objectAndProperty.getRepresentationMode();
        if (repMode.isExplicit()) {
            renderer.withMemberMode(repMode);
        }
        return Responses.ofOk(renderer, Caching.NONE);
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedCollection objectAndCollection) {
        this.ensureCompatibleAcceptHeader(RepresentationType.OBJECT_COLLECTION, resourceContext);
        return this.responseBuilder(this.buildResponseTo(resourceContext, objectAndCollection, JsonRepresentation.newMap((String[])new String[0]), null));
    }

    Response.ResponseBuilder buildResponseTo(IResourceContext resourceContext, ManagedCollection objectAndCollection, JsonRepresentation representation, JsonRepresentation rootRepresentation) {
        ObjectCollectionReprRenderer renderer = new ObjectCollectionReprRenderer(resourceContext, null, null, representation);
        renderer.with((ManagedMember)objectAndCollection).usingLinkTo(resourceContext.getObjectAdapterLinkTo());
        if (objectAndCollection.getRepresentationMode().isExplicit()) {
            renderer.withMemberMode(objectAndCollection.getRepresentationMode());
        }
        return Responses.ofOk(renderer, Caching.NONE, rootRepresentation);
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedAction objectAndAction) {
        this.ensureCompatibleAcceptHeader(RepresentationType.OBJECT_ACTION, resourceContext);
        AbstractObjectMemberReprRenderer renderer = new ObjectActionReprRenderer(resourceContext).with((ManagedMember)objectAndAction).usingLinkTo(resourceContext.getObjectAdapterLinkTo()).asStandalone();
        return this.responseBuilder(Responses.ofOk(renderer, Caching.NONE));
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ObjectAndActionInvocation objectAndActionInvocation) {
        boolean isDomainObjectOrCollection;
        List<MediaType> acceptableMediaTypes = resourceContext.getAcceptableMediaTypes();
        ObjectSpecification returnTypeCompileTimeSpecification = objectAndActionInvocation.getReturnTypeSpecification();
        boolean bl = isDomainObjectOrCollection = returnTypeCompileTimeSpecification.isEntityOrViewModelOrAbstract() || returnTypeCompileTimeSpecification.isPlural();
        if (isDomainObjectOrCollection && this.isAccepted(RepresentationType.DOMAIN_OBJECT, acceptableMediaTypes)) {
            return (Response.ResponseBuilder)objectAndActionInvocation.asEitherSingularOrPlural().fold(singularActionResult -> this.responseBuilder(this.buildResponse(resourceContext, (ManagedObject)singularActionResult)), pluralActionResult -> {
                ObjectSpecification elementSpec = objectAndActionInvocation.getAction().getElementType();
                ObjectSpecification actionOwnerSpec = ContentNegotiationServiceForRestfulObjectsV1_0.actionOwnerSpecFrom(objectAndActionInvocation);
                String actionId = ContentNegotiationServiceForRestfulObjectsV1_0.actionIdFrom(objectAndActionInvocation);
                String actionArguments = ContentNegotiationServiceForRestfulObjectsV1_0.actionArgumentsFrom(objectAndActionInvocation);
                DomainObjectList listAsViewmodel = ContentNegotiationServiceForRestfulObjectsV1_0.domainObjectListFrom(pluralActionResult, elementSpec, actionOwnerSpec, actionId, actionArguments);
                ObjectSpecification domainObjectListSpec = resourceContext.getMetaModelContext().getSpecificationLoader().specForType(DomainObjectList.class).filter(ObjectSpecification::isViewModel).orElseThrow(() -> _Exceptions.unrecoverable((String)"framework bug: DomainObjectList should be recognized as viewmodel"));
                ManagedObject listAdapter = ManagedObject.viewmodel((ObjectSpecification)domainObjectListSpec, (Object)listAsViewmodel, Optional.empty());
                return this.responseBuilder(this.buildResponse(resourceContext, listAdapter));
            });
        }
        if (this.isAccepted(RepresentationType.ACTION_RESULT, acceptableMediaTypes)) {
            return this.responseBuilder(this.buildResponseTo(resourceContext, objectAndActionInvocation, JsonRepresentation.newMap((String[])new String[0]), null));
        }
        throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.NOT_ACCEPTABLE);
    }

    protected Response.ResponseBuilder responseBuilder(Response.ResponseBuilder responseBuilder) {
        return responseBuilder;
    }

    private static ObjectSpecification actionOwnerSpecFrom(ObjectAndActionInvocation objectAndActionInvocation) {
        return objectAndActionInvocation.getAction().getDeclaringType();
    }

    private static String actionIdFrom(ObjectAndActionInvocation objectAndActionInvocation) {
        return objectAndActionInvocation.getAction().getId();
    }

    private static String actionArgumentsFrom(ObjectAndActionInvocation objectAndActionInvocation) {
        StringBuilder buf = new StringBuilder();
        Can parameters = objectAndActionInvocation.getAction().getParameters();
        Can<ManagedObject> argAdapters = objectAndActionInvocation.getArgAdapters();
        if (parameters.size() == argAdapters.size()) {
            for (int i = 0; i < parameters.size(); ++i) {
                int paramIndex = i;
                ObjectActionParameter param = (ObjectActionParameter)parameters.getElseFail(paramIndex);
                ManagedObject argAdapter = (ManagedObject)argAdapters.getElseFail(paramIndex);
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(param.getCanonicalFriendlyName()).append("=").append(ContentNegotiationServiceForRestfulObjectsV1_0.abbreviated(ContentNegotiationServiceForRestfulObjectsV1_0.titleOf(argAdapter), 8));
            }
        }
        return buf.toString();
    }

    private static String titleOf(ManagedObject argumentAdapter) {
        return argumentAdapter != null ? argumentAdapter.getTitle() : "";
    }

    private static String abbreviated(String str, int maxLength) {
        return str.length() < maxLength ? str : str.substring(0, maxLength - 3) + "...";
    }

    private static DomainObjectList domainObjectListFrom(Collection<ManagedObject> collectionAdapters, ObjectSpecification elementSpec, ObjectSpecification actionOwnerSpec, String actionId, String actionArguments) {
        String title = ContentNegotiationServiceForRestfulObjectsV1_0.titleFrom(collectionAdapters, elementSpec);
        DomainObjectList list = new DomainObjectList(title, elementSpec.fqcn(), actionOwnerSpec.fqcn(), actionId, actionArguments);
        for (ManagedObject adapter : collectionAdapters) {
            list.getObjects().add(adapter.getPojo());
        }
        return list;
    }

    private static String titleFrom(Collection<ManagedObject> collectionAdapters, ObjectSpecification elementSpec) {
        String singularName = elementSpec.getSingularName();
        return MmTitleUtils.formatAnyCardinalityAsTitle((int)collectionAdapters.size(), (String)singularName, (TranslationService)elementSpec.getTranslationService());
    }

    Response.ResponseBuilder buildResponseTo(IResourceContext resourceContext, ObjectAndActionInvocation objectAndActionInvocation, JsonRepresentation representation, JsonRepresentation rootRepresentation) {
        ActionResultReprRenderer renderer = new ActionResultReprRenderer(resourceContext, null, objectAndActionInvocation.getSelfLink(), representation);
        renderer.with(objectAndActionInvocation).using(resourceContext.getObjectAdapterLinkTo());
        Response.ResponseBuilder responseBuilder = Responses.ofOk(renderer, Caching.NONE, rootRepresentation);
        return responseBuilder;
    }

    private void ensureCompatibleAcceptHeader(RepresentationType representationType, IResourceContext resourceContext) {
        if (this.acceptChecking.isRelaxed()) {
            return;
        }
        if (representationType == null) {
            return;
        }
        String producedProfile = representationType.getMediaTypeProfile();
        if (producedProfile == null) {
            return;
        }
        if (!ContentNegotiationServiceForRestfulObjectsV1_0.isAccepted(producedProfile, resourceContext.getAcceptableMediaTypes())) {
            throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.NOT_ACCEPTABLE);
        }
    }

    private boolean isAccepted(RepresentationType representationType, List<MediaType> acceptableMediaTypes) {
        String producedProfile = representationType.getMediaTypeProfile();
        if (producedProfile != null) {
            return ContentNegotiationServiceForRestfulObjectsV1_0.isAccepted(producedProfile, acceptableMediaTypes);
        }
        if (this.acceptChecking.isStrict()) {
            throw new IllegalArgumentException("RepresentationType " + representationType + " does not specify a 'profile' parameter");
        }
        return false;
    }

    private static boolean isAccepted(@NonNull String producedProfile, List<MediaType> acceptableMediaTypes) {
        if (producedProfile == null) {
            throw new NullPointerException("producedProfile is marked non-null but is null");
        }
        for (MediaType mediaType : acceptableMediaTypes) {
            String acceptedProfileValue = (String)mediaType.getParameters().get("profile");
            if (acceptedProfileValue == null || producedProfile.equals(acceptedProfileValue)) continue;
            return false;
        }
        return true;
    }

    private static enum AcceptChecking {
        RELAXED,
        STRICT;


        static AcceptChecking fromConfig(CausewayConfiguration configuration) {
            return configuration.getViewer().getRestfulobjects().isStrictAcceptChecking() ? STRICT : RELAXED;
        }

        boolean isStrict() {
            return this == STRICT;
        }

        boolean isRelaxed() {
            return this == RELAXED;
        }
    }
}

