/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.apache.causeway.applib.services.swagger.Format;
import org.apache.causeway.applib.services.swagger.Visibility;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal.ClassExcluder;
import org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal.Tagger;
import org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal.ValueSchemaFactory;
import org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal._OpenApiModelFactory;
import org.springframework.stereotype.Component;

@Component
@Named(value="causeway.viewer.ro.OpenApiSpecGenerator")
public class OpenApiSpecGenerator {
    private final SpecificationLoader specificationLoader;
    private final Tagger tagger;
    private final ClassExcluder classExcluder;
    private final ValueSchemaFactory valuePropertyFactory;

    @Inject
    public OpenApiSpecGenerator(SpecificationLoader specificationLoader, Tagger tagger, ClassExcluder classExcluder, ValueSchemaFactory valuePropertyFactory) {
        this.specificationLoader = specificationLoader;
        this.tagger = tagger;
        this.classExcluder = classExcluder;
        this.valuePropertyFactory = valuePropertyFactory;
    }

    public String generate(String basePath, Visibility visibility, Format format) {
        _OpenApiModelFactory generation = this.newGeneration(basePath, visibility);
        OpenAPI swagger = generation.generate();
        switch (format) {
            case JSON: {
                return Json.pretty((Object)swagger);
            }
            case YAML: {
                try {
                    return Yaml.pretty().writeValueAsString((Object)swagger);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new IllegalArgumentException("Unrecognized format: " + format);
    }

    protected _OpenApiModelFactory newGeneration(String basePath, Visibility visibility) {
        return new _OpenApiModelFactory(basePath, visibility, this.specificationLoader, this.tagger, this.classExcluder, this.valuePropertyFactory);
    }
}

