/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.service.valuerender;

import com.fasterxml.jackson.databind.node.NullNode;
import java.util.OptionalInt;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.feature.HasObjectFeature;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.rendering.service.valuerender._JsonValueConverters;
import org.springframework.lang.Nullable;

public interface JsonValueConverter {
    @Nullable
    public Object recoverValueAsPojo(JsonRepresentation var1, Context var2);

    public Object asObject(ManagedObject var1, Context var2);

    public Object appendValueAndFormat(ManagedObject var1, Context var2, JsonRepresentation var3);

    public Class<?> getValueClass();

    public static abstract class Abstract
    implements JsonValueConverter {
        protected final String format;
        protected final String extendedFormat;
        private final Class<?> valueClass;

        public Abstract(_JsonValueConverters.DefaultFormat format) {
            this.format = format.format;
            this.extendedFormat = format.extendedFormat;
            this.valueClass = format.valueClass;
        }

        @Override
        public Object appendValueAndFormat(ManagedObject objectAdapter, Context context, JsonRepresentation repr) {
            Object value = Abstract.unwrapAsObjectElseNullNode(objectAdapter);
            repr.mapPut("value", value);
            this.appendFormats(repr, context);
            return value;
        }

        @Override
        public final Object asObject(ManagedObject objectAdapter, Context format) {
            return objectAdapter.getPojo();
        }

        protected final String effectiveFormat(String formatOverride) {
            return formatOverride != null ? formatOverride : this.format;
        }

        static Object unwrapAsObjectElseNullNode(ManagedObject adapter) {
            return adapter != null ? adapter.getPojo() : NullNode.getInstance();
        }

        void appendFormats(JsonRepresentation repr, Context context) {
            repr.putFormat(this.format);
            if (!context.isSuppressExtensions()) {
                repr.putExtendedFormat(this.extendedFormat);
            }
        }

        @Override
        public Class<?> getValueClass() {
            return this.valueClass;
        }
    }

    public static interface Context
    extends HasObjectFeature {
        public OptionalInt maxTotalDigits(@Nullable ManagedObject var1);

        public OptionalInt maxFractionalDigits(@Nullable ManagedObject var1);

        public boolean isSuppressExtensions();

        public static Context of(@NonNull ObjectFeature objectFeature, boolean suppressExtensions) {
            if (objectFeature == null) {
                throw new NullPointerException("objectFeature is marked non-null but is null");
            }
            return new InferredFromFacets(objectFeature, suppressExtensions);
        }

        public static Context forTesting(final Integer maxTotalDigits, final Integer maxFractionalDigits) {
            return new Context(){

                public ObjectFeature getObjectFeature() {
                    throw _Exceptions.notImplemented();
                }

                @Override
                public OptionalInt maxTotalDigits(ManagedObject value) {
                    return OptionalInt.of(maxTotalDigits);
                }

                @Override
                public OptionalInt maxFractionalDigits(ManagedObject value) {
                    return OptionalInt.of(maxFractionalDigits);
                }

                @Override
                public boolean isSuppressExtensions() {
                    return false;
                }
            };
        }

        public static final class InferredFromFacets
        implements Context {
            @NonNull
            private final ObjectFeature objectFeature;
            private final boolean suppressExtensions;

            @Override
            public OptionalInt maxTotalDigits(@Nullable ManagedObject value) {
                return Facets.maxTotalDigits(this.facetHolders(value));
            }

            @Override
            public OptionalInt maxFractionalDigits(@Nullable ManagedObject value) {
                return Facets.maxFractionalDigits(this.facetHolders(value));
            }

            private Can<FacetHolder> facetHolders(@Nullable ManagedObject value) {
                return ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)value) ? Can.of((Object[])new FacetHolder[]{this.objectFeature}) : Can.of((Object[])new FacetHolder[]{this.objectFeature, value.getSpecification()});
            }

            public InferredFromFacets(@NonNull ObjectFeature objectFeature, boolean suppressExtensions) {
                if (objectFeature == null) {
                    throw new NullPointerException("objectFeature is marked non-null but is null");
                }
                this.objectFeature = objectFeature;
                this.suppressExtensions = suppressExtensions;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InferredFromFacets)) {
                    return false;
                }
                InferredFromFacets other = (InferredFromFacets)o;
                if (this.isSuppressExtensions() != other.isSuppressExtensions()) {
                    return false;
                }
                ObjectFeature this$objectFeature = this.getObjectFeature();
                ObjectFeature other$objectFeature = other.getObjectFeature();
                return !(this$objectFeature == null ? other$objectFeature != null : !this$objectFeature.equals(other$objectFeature));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isSuppressExtensions() ? 79 : 97);
                ObjectFeature $objectFeature = this.getObjectFeature();
                result = result * 59 + ($objectFeature == null ? 43 : $objectFeature.hashCode());
                return result;
            }

            public String toString() {
                return "JsonValueConverter.Context.InferredFromFacets(objectFeature=" + this.getObjectFeature() + ", suppressExtensions=" + this.isSuppressExtensions() + ")";
            }

            @NonNull
            public ObjectFeature getObjectFeature() {
                return this.objectFeature;
            }

            @Override
            public boolean isSuppressExtensions() {
                return this.suppressExtensions;
            }
        }
    }
}

