/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.service.valuerender;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.value.semantics.ValueDecomposition;
import org.apache.causeway.applib.value.semantics.ValueSemanticsProvider;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.metamodel.facets.object.value.ValueFacet;
import org.apache.causeway.core.metamodel.facets.object.value.ValueSerializer;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.schema.common.v2.ValueType;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.rendering.service.valuerender.JsonValueConverter;
import org.apache.causeway.viewer.restfulobjects.rendering.service.valuerender.JsonValueEncoderService;
import org.apache.causeway.viewer.restfulobjects.rendering.service.valuerender._JsonValueConverters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;

@Service
@Named(value="causeway.viewer.ro.JsonValueEncoderDefault")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class JsonValueEncoderServiceDefault
implements JsonValueEncoderService {
    @Generated
    private static final Logger log = LogManager.getLogger(JsonValueEncoderServiceDefault.class);
    private final SpecificationLoader specificationLoader;
    private final Map<Class<?>, JsonValueConverter> converterByClass;

    @Inject
    public JsonValueEncoderServiceDefault(SpecificationLoader specificationLoader) {
        this.specificationLoader = specificationLoader;
        this.converterByClass = _JsonValueConverters.byClass();
    }

    @Override
    public ManagedObject asAdapter(ObjectSpecification spec, JsonRepresentation valueRepr, JsonValueConverter.Context context) {
        if (valueRepr == null) {
            return null;
        }
        if (spec == null) {
            throw new IllegalArgumentException("ObjectSpecification is required");
        }
        if (!spec.isValue()) {
            throw new IllegalArgumentException("Representation must be of a value");
        }
        Class valueClass = spec.getCorrespondingClass();
        if (ClassUtils.isPrimitiveOrWrapper((Class)valueClass)) {
            Class primitiveWrapper = ClassUtils.resolvePrimitiveIfNecessary((Class)valueClass);
            if (Boolean.class.equals((Object)primitiveWrapper)) {
                this.booleanRepresentationCheck(valueRepr);
            } else if (Character.class.equals((Object)primitiveWrapper)) {
                this.characterRepresentationCheck(valueRepr);
            }
        }
        if (spec.isCompositeValue()) {
            _Assert.assertTrue((boolean)valueRepr.isString(), () -> "expected to receive a String originating from ValueDecomposition#stringify");
            ValueFacet valueFacet = spec.valueFacetElseFail();
            ValueSemanticsProvider valSemantics = (ValueSemanticsProvider)valueFacet.selectDefaultSemantics().orElseThrow();
            ValueDecomposition valDecomposition = ValueDecomposition.destringify((ValueType)ValueType.COMPOSITE, (String)valueRepr.asString());
            Object pojo = valSemantics.compose(valDecomposition);
            return ManagedObject.value((ObjectSpecification)spec, (Object)pojo);
        }
        return this.asAdapterUsingStaticConverters(spec, valueRepr, context).orElseGet(() -> this.asAdapterUsingValueSemantics(spec, valueRepr, context));
    }

    private ManagedObject asAdapterUsingValueSemantics(ObjectSpecification spec, JsonRepresentation valueRepr, JsonValueConverter.Context context) {
        Class valueClass = spec.getCorrespondingClass();
        ValueSerializer valueSerializer = Facets.valueSerializerElseFail((ObjectSpecification)spec, (Class)valueClass);
        if (valueRepr.isMap()) {
            String json = valueRepr.asJsonNode().toString();
            Object pojo2 = valueSerializer.destring(ValueSerializer.Format.JSON, json);
            return ManagedObject.value((ObjectSpecification)spec, (Object)pojo2);
        }
        return JsonValueEncoderServiceDefault.recoverPojoFromStringElseFail(valueRepr, valueSerializer).map(pojo -> ManagedObject.value((ObjectSpecification)spec, (Object)pojo)).orElseGet(() -> ManagedObject.empty((ObjectSpecification)spec));
    }

    private Optional<ManagedObject> asAdapterUsingStaticConverters(ObjectSpecification spec, JsonRepresentation valueRepr, JsonValueConverter.Context context) {
        Class valueClass = spec.getCorrespondingClass();
        return Optional.ofNullable(this.converterByClass.get(ClassUtils.resolvePrimitiveIfNecessary((Class)valueClass))).map(jsonValueConverter -> jsonValueConverter.recoverValueAsPojo(valueRepr, context)).map(valueAsPojo -> ManagedObject.value((ObjectSpecification)spec, (Object)valueAsPojo));
    }

    private static Optional<Object> recoverPojoFromStringElseFail(JsonRepresentation valueRepr, ValueSerializer<?> valueSerializer) {
        if (valueRepr.isString()) {
            Object recoveredValue = Try.call(() -> valueSerializer.destring(ValueSerializer.Format.JSON, valueRepr.asString())).mapFailure(ex -> _Exceptions.illegalArgument((Throwable)ex, (String)"Unable to parse value %s as from String representation", (Object[])new Object[]{valueRepr})).valueAsNullableElseFail();
            return Optional.ofNullable(recoveredValue);
        }
        throw _Exceptions.illegalArgument((String)"Unable to parse value %s from String representation (using 'String' as a fallback attempt)", (Object[])new Object[]{valueRepr});
    }

    @Override
    public void appendValueAndFormat(ManagedObject valueAdapter, JsonRepresentation repr, JsonValueConverter.Context context) {
        ObjectSpecification valueSpec = valueAdapter.getSpecification();
        Class valueClass = valueSpec.getCorrespondingClass();
        JsonValueConverter jsonValueConverter = this.converterByClass.get(valueClass);
        if (jsonValueConverter != null) {
            jsonValueConverter.appendValueAndFormat(valueAdapter, context, repr);
            return;
        }
        Optional<ValueDecomposition> valueDecompositionIfAny = JsonValueEncoderServiceDefault.decompose(valueAdapter);
        if (valueDecompositionIfAny.isPresent()) {
            ValueDecomposition valueDecomposition = valueDecompositionIfAny.get();
            String valueAsJson = valueDecomposition.toJson();
            valueDecomposition.accept(simple -> {
                if (simple.getType() == ValueType.BLOB || simple.getType() == ValueType.CLOB || simple.getType() == ValueType.ENUM) {
                    JsonRepresentation decompRepr = JsonRepresentation.jsonAsMap((String)valueAsJson);
                    if (simple.getType() == ValueType.ENUM) {
                        decompRepr.mapPutString("enumTitle", valueAdapter.getTitle());
                    }
                    repr.mapPutJsonRepresentation("value", decompRepr);
                    this.appendFormats(repr, null, simple.getType().value(), context.isSuppressExtensions());
                } else {
                    repr.mapPutString("value", valueAsJson);
                    this.appendFormats(repr, "string", simple.getType().value(), context.isSuppressExtensions());
                }
            }, tuple -> {
                JsonRepresentation decompRepr = JsonRepresentation.jsonAsMap((String)valueAsJson);
                repr.mapPutJsonRepresentation("value", decompRepr);
                String typeTupleAsFormat = "{" + tuple.getElements().stream().map(el -> el.getType().value()).collect(Collectors.joining(",")) + "}";
                this.appendFormats(repr, null, typeTupleAsFormat, context.isSuppressExtensions());
            });
        } else {
            this.appendNullAndFormat(repr, context.isSuppressExtensions());
        }
    }

    private static Optional<ValueDecomposition> decompose(ManagedObject valueAdapter) {
        if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)valueAdapter)) {
            return Optional.empty();
        }
        Class valueClass = valueAdapter.getSpecification().getCorrespondingClass();
        Optional<ValueDecomposition> decompositionIfAny = Facets.valueDefaultSemantics((ObjectSpecification)valueAdapter.getSpecification(), (Class)valueClass).map(composer -> composer.decompose(_Casts.uncheckedCast((Object)valueAdapter.getPojo())));
        if (decompositionIfAny.isEmpty()) {
            ObjectSpecification valueSpec = valueAdapter.getSpecification();
            log.warn("{Could not resolve a ValueComposer for {}, falling back to rendering as 'null'. Make sure the framework has access to a ValueSemanticsProvider<{}> that implements ValueComposer<{}>}", (Object)valueSpec.getLogicalTypeName(), (Object)valueSpec.getCorrespondingClass().getSimpleName(), (Object)valueSpec.getCorrespondingClass().getSimpleName());
        }
        return decompositionIfAny;
    }

    @Override
    @Nullable
    public Object asObject(@NonNull ManagedObject adapter, JsonValueConverter.Context context) {
        if (adapter == null) {
            throw new NullPointerException("adapter is marked non-null but is null");
        }
        ObjectSpecification objectSpec = adapter.getSpecification();
        Class cls = objectSpec.getCorrespondingClass();
        JsonValueConverter jsonValueConverter = this.converterByClass.get(cls);
        if (jsonValueConverter != null) {
            return jsonValueConverter.asObject(adapter, context);
        }
        return Facets.valueSerializerElseFail((ObjectSpecification)objectSpec, (Class)cls).enstring(ValueSerializer.Format.JSON, _Casts.uncheckedCast((Object)adapter.getPojo()));
    }

    private void booleanRepresentationCheck(JsonRepresentation valueRepr) {
        if (!valueRepr.isBoolean()) {
            throw new IllegalArgumentException("Representation must be boolean");
        }
    }

    private void characterRepresentationCheck(JsonRepresentation valueRepr) {
        if (valueRepr.isString() && _NullSafe.size((String)valueRepr.asString()) <= 1) {
            return;
        }
        throw new IllegalArgumentException("Representation must be a single character string");
    }
}

