/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.domainobjects;

import com.fasterxml.jackson.databind.node.NullNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedMember;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedParameter;
import org.apache.causeway.core.metamodel.interactions.managed.ParameterNegotiationModel;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.Rel;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.AbstractObjectMemberReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.InvokeKeys;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.MutatorSpec;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.causeway.viewer.restfulobjects.rendering.domaintypes.ActionDescriptionReprRenderer;

public class ObjectActionReprRenderer
extends AbstractObjectMemberReprRenderer<ObjectAction> {
    public ObjectActionReprRenderer(IResourceContext resourceContext) {
        this(resourceContext, (LinkFollowSpecs)null, (String)null, JsonRepresentation.newMap((String[])new String[0]));
    }

    public ObjectActionReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollowSpecs, String actionId, JsonRepresentation representation) {
        super(resourceContext, linkFollowSpecs, actionId, RepresentationType.OBJECT_ACTION, representation, Where.OBJECT_FORMS);
    }

    @Override
    public JsonRepresentation render() {
        this.renderMemberContent();
        this.putDisabledReasonIfDisabled();
        if (this.mode.isStandalone() || this.mode.isMutated()) {
            this.addParameterDetails();
        }
        return this.representation;
    }

    @Override
    protected void followDetailsLink(JsonRepresentation detailsLink) {
        Where where = this.resourceContext.getWhere();
        ObjectActionReprRenderer renderer = new ObjectActionReprRenderer(this.getResourceContext(), this.getLinkFollowSpecs(), null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.with((ManagedMember)ManagedAction.of((ManagedObject)this.objectAdapter, (ObjectAction)((ObjectAction)this.objectMember), (Where)where)).usingLinkTo(this.linkTo).asFollowed();
        detailsLink.mapPutJsonRepresentation("value", renderer.render());
    }

    @Override
    protected void addMutatorLinksIfEnabled() {
        if (this.usability().isVetoed()) {
            return;
        }
        Map<String, MutatorSpec> mutators = this.objectMemberType.getMutators();
        SemanticsOf actionSemantics = ((ObjectAction)this.objectMember).getSemantics();
        String mutator = InvokeKeys.getKeyFor(actionSemantics);
        MutatorSpec mutatorSpec = mutators.get(mutator);
        this.addLinkFor(mutatorSpec);
    }

    @Override
    protected ObjectAdapterLinkTo linkToForMutatorInvoke() {
        return super.linkToForMutatorInvoke();
    }

    @Override
    protected JsonRepresentation mutatorArgs(MutatorSpec mutatorSpec) {
        JsonRepresentation argMap = JsonRepresentation.newMap((String[])new String[0]);
        Can parameters = ((ObjectAction)this.objectMember).getParameters();
        for (int i = 0; i < ((ObjectAction)this.objectMember).getParameterCount(); ++i) {
            argMap.mapPut(((ObjectActionParameter)parameters.getElseFail(i)).getId() + ".value", this.argValueFor(i));
        }
        return argMap;
    }

    private Object argValueFor(int i) {
        return NullNode.getInstance();
    }

    private ObjectActionReprRenderer addParameterDetails() {
        LinkedHashMap parameters = _Maps.newLinkedHashMap();
        if (((ObjectAction)this.objectMember).getParameterCount() > 0) {
            ManagedAction act = ManagedAction.of((ManagedObject)this.objectAdapter, (ObjectAction)((ObjectAction)this.objectMember), (Where)Where.ANYWHERE);
            ParameterNegotiationModel paramNeg = act.startParameterNegotiation();
            for (ManagedParameter paramMod : paramNeg.getParamModels()) {
                ObjectActionParameter paramMeta = paramMod.getMetaModel();
                Object paramDetails = this.paramDetails(paramMod, paramNeg);
                parameters.put(paramMeta.getId(), paramDetails);
            }
        }
        this.representation.mapPut("parameters", (Object)parameters);
        return this;
    }

    private Object paramDetails(ManagedParameter paramMod, ParameterNegotiationModel paramNeg) {
        Object paramDefault;
        ObjectActionParameter paramMeta = paramMod.getMetaModel();
        JsonRepresentation paramRep = JsonRepresentation.newMap((String[])new String[0]);
        paramRep.mapPutInt("num", paramMeta.getParameterIndex());
        paramRep.mapPutString("id", paramMeta.getId());
        paramRep.mapPutString("name", paramMeta.getFriendlyName(this.objectAdapter.asSupplier()));
        paramRep.mapPut("description", (Object)paramMeta.getDescription(this.objectAdapter.asSupplier()));
        Object paramChoices = this.choicesFor(paramMod, paramNeg);
        if (paramChoices != null) {
            paramRep.mapPut("choices", paramChoices);
        }
        if ((paramDefault = this.defaultFor(paramMod)) != null) {
            paramRep.mapPut("default", paramDefault);
        }
        return paramRep;
    }

    private Object choicesFor(ManagedParameter paramMod, ParameterNegotiationModel paramNeg) {
        ObjectActionParameter paramMeta = paramMod.getMetaModel();
        Can choiceAdapters = paramMeta.getChoices(paramNeg, this.getInteractionInitiatedBy());
        if (choiceAdapters == null || choiceAdapters.isEmpty()) {
            return null;
        }
        ArrayList list = _Lists.newArrayList();
        for (ManagedObject choiceAdapter : choiceAdapters) {
            list.add(DomainObjectReprRenderer.valueOrRef(this.resourceContext, (ObjectFeature)paramMeta, this.getJsonValueEncoder(), choiceAdapter));
        }
        return list;
    }

    private Object defaultFor(ManagedParameter paramMod) {
        ManagedObject defaultAdapter = (ManagedObject)paramMod.getValue().getValue();
        if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)defaultAdapter)) {
            return null;
        }
        ObjectActionParameter paramMeta = paramMod.getMetaModel();
        return DomainObjectReprRenderer.valueOrRef(this.resourceContext, (ObjectFeature)paramMeta, this.getJsonValueEncoder(), defaultAdapter);
    }

    @Override
    protected void addLinksToFormalDomainModel() {
        if (this.resourceContext.config().isSuppressDescribedByLinks()) {
            return;
        }
        JsonRepresentation link = ActionDescriptionReprRenderer.newLinkToBuilder(this.resourceContext, Rel.DESCRIBEDBY, this.objectAdapter.getSpecification(), (ObjectAction)this.objectMember).build();
        this.getLinks().arrayAdd(link);
    }

    @Override
    protected void putExtensionsCausewayProprietary() {
        this.getExtensions().mapPutString("actionScope", ((ObjectAction)this.objectMember).getScope().name().toLowerCase());
        SemanticsOf semantics = ((ObjectAction)this.objectMember).getSemantics();
        this.getExtensions().mapPutString("actionSemantics", semantics.getCamelCaseName());
    }
}

