/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.domaintypes;

import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.causeway.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.causeway.viewer.restfulobjects.rendering.domaintypes.ParentSpecAndFeature;

public abstract class AbstractTypeFeatureReprRenderer<T extends ObjectFeature>
extends ReprRendererAbstract<ParentSpecAndFeature<T>> {
    protected ObjectSpecification objectSpecification;
    protected T objectFeature;

    public AbstractTypeFeatureReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollower, RepresentationType representationType, JsonRepresentation representation) {
        super(resourceContext, linkFollower, representationType, representation);
    }

    public ObjectSpecification getParentSpecification() {
        return this.objectSpecification;
    }

    public T getObjectFeature() {
        return this.objectFeature;
    }

    @Override
    public AbstractTypeFeatureReprRenderer<T> with(ParentSpecAndFeature<T> specAndFeature) {
        this.objectSpecification = specAndFeature.getParentSpec();
        this.objectFeature = specAndFeature.getObjectFeature();
        return this;
    }

    @Override
    public JsonRepresentation render() {
        this.addLinkSelfIfRequired();
        this.addLinkUpToParent();
        this.addPropertiesSpecificToFeature();
        this.addLinksSpecificToFeature();
        this.putExtensionsSpecificToFeature();
        return this.representation;
    }

    protected void addPropertiesSpecificToFeature() {
    }

    protected abstract void addLinkSelfIfRequired();

    protected abstract void addLinkUpToParent();

    protected void addLinksSpecificToFeature() {
    }

    protected abstract void putExtensionsSpecificToFeature();

    protected void putExtensionsName() {
        this.getObjectFeature().getStaticOrCanonicalFriendlyName().accept(staticForm -> {
            this.getExtensions().mapPutString("friendlyName", staticForm);
            this.getExtensions().mapPutString("friendlyNameForm", "static");
        }, canonicalForm -> {
            this.getExtensions().mapPutString("friendlyName", canonicalForm);
            this.getExtensions().mapPutString("friendlyNameForm", "canonical");
        });
    }

    protected void putExtensionsDescriptionIfAvailable() {
        this.getObjectFeature().getStaticOrCanonicalDescription().ifPresent(description -> description.accept(staticForm -> {
            if (staticForm.isEmpty()) {
                return;
            }
            this.getExtensions().mapPutString("description", staticForm);
            this.getExtensions().mapPutString("descriptionForm", "static");
        }, canonicalForm -> {
            if (canonicalForm.isEmpty()) {
                return;
            }
            this.getExtensions().mapPutString("description", canonicalForm);
            this.getExtensions().mapPutString("descriptionForm", "canonical");
        }));
    }
}

