/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.service.swagger;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import org.apache.causeway.applib.CausewayModuleApplib;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.DomainService;
import org.apache.causeway.applib.annotation.DomainServiceLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.ParameterLayout;
import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.applib.annotation.Publishing;
import org.apache.causeway.applib.annotation.RestrictTo;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.services.registry.ServiceRegistry;
import org.apache.causeway.applib.services.swagger.Format;
import org.apache.causeway.applib.services.swagger.SwaggerService;
import org.apache.causeway.applib.services.swagger.Visibility;
import org.apache.causeway.applib.value.Clob;
import org.apache.causeway.applib.value.LocalResourcePath;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.core.config.RestEasyConfiguration;

@Named(value="causeway.viewer.roRendering.SwaggerServiceMenu")
@DomainService
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY)
@Priority(value=0x1FFFFFFF)
public class SwaggerServiceMenu {
    public static final String LOGICAL_TYPE_NAME = "causeway.viewer.roRendering.SwaggerServiceMenu";
    private final SwaggerService swaggerService;
    private final ServiceRegistry serviceRegistry;
    private final RestEasyConfiguration restEasyConfiguration;
    private final String basePath;

    @Inject
    public SwaggerServiceMenu(SwaggerService swaggerService, ServiceRegistry serviceRegistry, RestEasyConfiguration restEasyConfiguration) {
        this.swaggerService = swaggerService;
        this.serviceRegistry = serviceRegistry;
        this.restEasyConfiguration = restEasyConfiguration;
        this.basePath = this.restEasyConfiguration.getJaxrs().getDefaultPath() + "/";
    }

    @Programmatic
    String disableReasonWhenRequiresROViewer() {
        Optional moduleIfAny = this.serviceRegistry.lookupBeanById("causeway.viewer.ro.WebModuleJaxrsRestEasy");
        return moduleIfAny.isPresent() ? null : "RestfulObjects viewer is not configured";
    }

    private static String buildFileName(String fileNamePrefix, Visibility visibility, Format format) {
        String formatLower = format.name().toLowerCase();
        int i = fileNamePrefix.lastIndexOf("." + formatLower);
        if (i > 0) {
            fileNamePrefix = fileNamePrefix.substring(0, i);
        }
        return _Strings.asFileNameWithExtension((String)(fileNamePrefix + "-" + visibility.name().toLowerCase()), (String)formatLower);
    }

    @Action(commandPublishing=Publishing.DISABLED, domainEvent=ActionDomainEvent.class, executionPublishing=Publishing.DISABLED, restrictTo=RestrictTo.PROTOTYPING, semantics=SemanticsOf.SAFE)
    @ActionLayout(cssClassFa="fa-download", sequence="500.600.3")
    public class downloadSwaggerSchemaDefinition {
        @MemberSupport
        public Clob act(@ParameterLayout(named="Filename") String fileNamePrefix, Visibility visibility, Format format) {
            String fileName = SwaggerServiceMenu.buildFileName(fileNamePrefix, visibility, format);
            String spec = SwaggerServiceMenu.this.swaggerService.generateSwaggerSpec(visibility, format);
            return new Clob(fileName, format.mediaType(), (CharSequence)spec);
        }

        @MemberSupport
        public String default0Act() {
            return "swagger";
        }

        @MemberSupport
        public Visibility default1Act() {
            return Visibility.PRIVATE;
        }

        @MemberSupport
        public Format default2Act() {
            return Format.YAML;
        }

        public class ActionDomainEvent
        extends org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.SwaggerServiceMenu$ActionDomainEvent<downloadSwaggerSchemaDefinition> {
        }
    }

    @Action(commandPublishing=Publishing.DISABLED, domainEvent=ActionDomainEvent.class, executionPublishing=Publishing.DISABLED, restrictTo=RestrictTo.PROTOTYPING, semantics=SemanticsOf.SAFE)
    @ActionLayout(cssClassFa="fa-external-link-alt", sequence="500.600.2")
    public class openRestApi {
        @MemberSupport
        public LocalResourcePath act() {
            return new LocalResourcePath(SwaggerServiceMenu.this.basePath);
        }

        @MemberSupport
        public String disableAct() {
            return SwaggerServiceMenu.this.disableReasonWhenRequiresROViewer();
        }

        public class ActionDomainEvent
        extends org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.SwaggerServiceMenu$ActionDomainEvent<openRestApi> {
        }
    }

    @Action(commandPublishing=Publishing.DISABLED, domainEvent=ActionDomainEvent.class, executionPublishing=Publishing.DISABLED, restrictTo=RestrictTo.PROTOTYPING, semantics=SemanticsOf.SAFE)
    @ActionLayout(cssClassFa="fa-external-link-alt", sequence="500.600.1")
    public class openSwaggerUi {
        @MemberSupport
        public LocalResourcePath act() {
            return new LocalResourcePath("/swagger-ui/index.thtml");
        }

        @MemberSupport
        public String disableAct() {
            return SwaggerServiceMenu.this.disableReasonWhenRequiresROViewer();
        }

        public class ActionDomainEvent
        extends org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.SwaggerServiceMenu$ActionDomainEvent<openSwaggerUi> {
        }
    }

    public static abstract class ActionDomainEvent<T>
    extends CausewayModuleApplib.ActionDomainEvent<T> {
    }
}

