/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.resources;

import javax.ws.rs.core.Response;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.collections._Collections;
import org.apache.causeway.commons.io.JaxbUtils;
import org.apache.causeway.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.logging.log4j.Logger;

final class _EndpointLogging {
    static String stringResponse(Logger log, String format, String stringResponse) {
        if (log.isDebugEnabled()) {
            _EndpointLogging.logRequest(log, format, new Object[0]);
            _EndpointLogging.logResponse(log, stringResponse);
        }
        return stringResponse;
    }

    static Response response(Logger log, String format, Response response) {
        if (log.isDebugEnabled()) {
            _EndpointLogging.logRequest(log, format, new Object[0]);
            _EndpointLogging.logResponse(log, response);
        }
        return response;
    }

    static Response response(Logger log, String format, String arg0, Response response) {
        if (log.isDebugEnabled()) {
            _EndpointLogging.logRequest(log, format, arg0);
            _EndpointLogging.logResponse(log, response);
        }
        return response;
    }

    static Response response(Logger log, String format, String arg0, String arg1, Response response) {
        if (log.isDebugEnabled()) {
            _EndpointLogging.logRequest(log, format, arg0, arg1);
            _EndpointLogging.logResponse(log, response);
        }
        return response;
    }

    static Response response(Logger log, String format, String arg0, String arg1, String arg2, Response response) {
        if (log.isDebugEnabled()) {
            _EndpointLogging.logRequest(log, format, arg0, arg1, arg2);
            _EndpointLogging.logResponse(log, response);
        }
        return response;
    }

    static RestfulObjectsApplicationException error(Logger log, String format, RestfulObjectsApplicationException roException) {
        if (log.isDebugEnabled()) {
            _EndpointLogging.logRequest(log, format, new Object[0]);
            _EndpointLogging.logError(log, roException);
        }
        return roException;
    }

    static RestfulObjectsApplicationException error(Logger log, String format, String arg0, RestfulObjectsApplicationException roException) {
        if (log.isDebugEnabled()) {
            _EndpointLogging.logRequest(log, format, arg0);
            _EndpointLogging.logError(log, roException);
        }
        return roException;
    }

    static RestfulObjectsApplicationException error(Logger log, String format, String arg0, String arg1, RestfulObjectsApplicationException roException) {
        if (log.isDebugEnabled()) {
            _EndpointLogging.logRequest(log, format, arg0, arg1);
            _EndpointLogging.logError(log, roException);
        }
        return roException;
    }

    static RestfulObjectsApplicationException error(Logger log, String format, String arg0, String arg1, String arg2, RestfulObjectsApplicationException roException) {
        if (log.isDebugEnabled()) {
            _EndpointLogging.logRequest(log, format, arg0, arg1, arg2);
            _EndpointLogging.logError(log, roException);
        }
        return roException;
    }

    private static void logRequest(Logger log, String format, Object ... args) {
        log.debug(">>> REQUEST");
        log.debug(format, args);
    }

    private static void logResponse(Logger log, Response response) {
        log.debug("<<< RESPONSE");
        Object dto = response.getEntity();
        if (dto == null || dto instanceof String) {
            log.debug(dto);
        } else if (_Collections.isAnyCollectionOrArrayType(dto.getClass())) {
            log.debug("non-scalar content of type {}", dto.getClass());
        } else {
            Try.call(() -> JaxbUtils.toStringUtf8((Object)dto, (JaxbUtils.JaxbCustomizer[])new JaxbUtils.JaxbCustomizer[]{opts -> opts.useContextCache(true).formattedOutput(true)})).ifSuccess(xml -> log.debug(xml)).ifFailure(toXmlConversionError -> log.debug("could not convert response content to XML for logging: {}", (Object)toXmlConversionError.getMessage(), toXmlConversionError));
        }
        log.debug("--- END RESPONSE");
    }

    private static void logResponse(Logger log, String stringResponse) {
        log.debug("<<< RESPONSE");
        log.debug(stringResponse);
        log.debug("--- END RESPONSE");
    }

    private static void logError(Logger log, RestfulObjectsApplicationException roException) {
        log.debug("<<< ERROR");
        log.debug((Object)roException.getBody());
        log.debug("--- END ERROR");
    }

    private _EndpointLogging() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

