/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.resources;

import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.causeway.applib.services.iactnlayer.InteractionService;
import org.apache.causeway.applib.services.swagger.Format;
import org.apache.causeway.applib.services.swagger.SwaggerService;
import org.apache.causeway.applib.services.swagger.Visibility;
import org.apache.causeway.viewer.restfulobjects.viewer.resources._EndpointLogging;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
@Path(value="/swagger")
public class SwaggerSpecResource {
    private static final Logger log = LogManager.getLogger(SwaggerSpecResource.class);
    private final SwaggerService swaggerService;
    private final InteractionService interactionService;
    @Context
    HttpHeaders httpHeaders;
    @Context
    HttpServletRequest httpServletRequest;

    @Inject
    public SwaggerSpecResource(@Context SwaggerService swaggerService, @Context InteractionService interactionService) {
        this.swaggerService = swaggerService;
        this.interactionService = interactionService;
        log.debug("<init>");
    }

    @Path(value="/private")
    @GET
    @Consumes(value={"*/*", "application/json", "text/yaml"})
    @Produces(value={"application/json", "text/yaml"})
    public String swaggerPrivate() {
        return _EndpointLogging.stringResponse(log, "GET /swagger/private", this.swagger(Visibility.PRIVATE));
    }

    @Path(value="/prototyping")
    @GET
    @Consumes(value={"*/*", "application/json", "text/yaml"})
    @Produces(value={"application/json", "text/yaml"})
    public String swaggerPrototyping() {
        return _EndpointLogging.stringResponse(log, "GET /swagger/prototyping", this.swagger(Visibility.PRIVATE_WITH_PROTOTYPING));
    }

    @Path(value="/public")
    @GET
    @Consumes(value={"*/*", "application/json", "text/yaml"})
    @Produces(value={"application/json", "text/yaml"})
    public String swaggerPublic() {
        return _EndpointLogging.stringResponse(log, "GET /swagger/public", this.swagger(Visibility.PUBLIC));
    }

    private String swagger(Visibility visibility) {
        Format format = this.deriveFrom(this.httpHeaders);
        MyCallable callable = new MyCallable(this.swaggerService, visibility, format);
        String spec = (String)this.interactionService.callAnonymous((Callable)callable);
        return spec;
    }

    private Format deriveFrom(HttpHeaders httpHeaders) {
        List acceptableMediaTypes = httpHeaders.getAcceptableMediaTypes();
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            if (!acceptableMediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) continue;
            return Format.JSON;
        }
        MediaType applYaml = new MediaType("application", "yaml");
        MediaType textYaml = new MediaType("text", "yaml");
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            if (!acceptableMediaType.isCompatible(applYaml) && !acceptableMediaType.isCompatible(textYaml)) continue;
            return Format.YAML;
        }
        return Format.JSON;
    }

    static class MyCallable
    implements Callable<String> {
        private final SwaggerService swaggerService;
        private final Visibility visibility;
        private final Format format;

        @Override
        public String call() throws Exception {
            return this.swaggerService.generateSwaggerSpec(this.visibility, this.format);
        }

        public MyCallable(SwaggerService swaggerService, Visibility visibility, Format format) {
            this.swaggerService = swaggerService;
            this.visibility = visibility;
            this.format = format;
        }
    }
}

