/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.resources;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.causeway.viewer.restfulobjects.applib.version.VersionResource;
import org.apache.causeway.viewer.restfulobjects.rendering.Caching;
import org.apache.causeway.viewer.restfulobjects.rendering.ReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.Responses;
import org.apache.causeway.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.causeway.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.causeway.viewer.restfulobjects.viewer.context.ResourceContext;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.ResourceAbstract;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.VersionReprRenderer;
import org.apache.causeway.viewer.restfulobjects.viewer.resources._EndpointLogging;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
@Path(value="/version")
public class VersionResourceServerside
extends ResourceAbstract
implements VersionResource {
    private static final Logger log = LogManager.getLogger(VersionResourceServerside.class);

    @Inject
    public VersionResourceServerside() {
        log.debug("<init>");
    }

    @GET
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/version\""})
    public Response version() {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.VERSION, Where.NOWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        this.fakeRuntimeExceptionIfXFail(resourceContext);
        VersionReprRenderer renderer = new VersionReprRenderer(resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.includesSelf();
        return _EndpointLogging.response(log, "GET /version", Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_DAY).build());
    }

    public Response deleteVersionNotAllowed() {
        throw _EndpointLogging.error(log, "DELETE /version", RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting the version resource is not allowed.", (Object[])new Object[0]));
    }

    public Response putVersionNotAllowed() {
        throw _EndpointLogging.error(log, "PUT /version", RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to the version resource is not allowed.", (Object[])new Object[0]));
    }

    public Response postVersionNotAllowed() {
        throw _EndpointLogging.error(log, "POST /version", RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to the version resource is not allowed.", (Object[])new Object[0]));
    }

    private void fakeRuntimeExceptionIfXFail(ResourceContext resourceContext) {
        HttpHeaders httpHeaders = resourceContext.getHttpHeaders();
        List requestHeader = httpHeaders.getRequestHeader("X-Fail");
        if (requestHeader != null && !requestHeader.isEmpty()) {
            throw _EndpointLogging.error(log, "GET /version", RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_FAILURE));
        }
    }
}

