/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.resources;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.applib.services.iactnlayer.InteractionService;
import org.apache.causeway.core.security.authentication.manager.AuthenticationManager;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.causeway.viewer.restfulobjects.applib.user.UserResource;
import org.apache.causeway.viewer.restfulobjects.rendering.Caching;
import org.apache.causeway.viewer.restfulobjects.rendering.ReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.Responses;
import org.apache.causeway.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.causeway.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.causeway.viewer.restfulobjects.viewer.context.ResourceContext;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.HomePageReprRenderer;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.ResourceAbstract;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.UserReprRenderer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class UserResourceServerside
extends ResourceAbstract
implements UserResource {
    @Generated
    private static final Logger log = LogManager.getLogger(UserResourceServerside.class);

    public UserResourceServerside() {
        log.debug("<init>");
    }

    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/user\""})
    public Response user() {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.USER, Where.NOWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        UserReprRenderer renderer = new UserReprRenderer(resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.includesSelf().with((Object)resourceContext.getInteractionService().currentInteractionContextElseFail());
        return Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_HOUR).build();
    }

    public Response deleteUserNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting the user resource is not allowed.", (Object[])new Object[0]);
    }

    public Response putUserNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to the user resource is not allowed.", (Object[])new Object[0]);
    }

    public Response postUserNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to the user resource is not allowed.", (Object[])new Object[0]);
    }

    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/homepage\""})
    public Response logout() {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.HOME_PAGE, Where.NOWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        HomePageReprRenderer renderer = new HomePageReprRenderer(resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.includesSelf();
        this.logout(resourceContext);
        try {
            URI location = new URI("?__causeway_force_logout");
            return Response.temporaryRedirect((URI)location).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void logout(ResourceContext resourceContext) {
        InteractionService interactionService = resourceContext.getInteractionService();
        AuthenticationManager authenticationManager = resourceContext.getAuthenticationManager();
        interactionService.currentInteractionContext().ifPresent(interactionContext -> {
            authenticationManager.closeSession(interactionContext.getUser());
            interactionService.closeInteractionLayers();
        });
    }
}

