/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.resources;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.applib.layout.component.ActionLayoutData;
import org.apache.causeway.applib.layout.component.CollectionLayoutData;
import org.apache.causeway.applib.layout.component.DomainObjectLayoutData;
import org.apache.causeway.applib.layout.component.PropertyLayoutData;
import org.apache.causeway.applib.layout.grid.Grid;
import org.apache.causeway.applib.layout.links.Link;
import org.apache.causeway.commons.io.UrlUtils;
import org.apache.causeway.core.metamodel.consent.Consent;
import org.apache.causeway.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.causeway.core.metamodel.facets.object.icon.ObjectIcon;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedMember;
import org.apache.causeway.core.metamodel.interactions.managed.MemberInteraction;
import org.apache.causeway.core.metamodel.interactions.managed.PropertyInteraction;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.MmEntityUtils;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.Rel;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.causeway.viewer.restfulobjects.applib.domainobjects.DomainObjectResource;
import org.apache.causeway.viewer.restfulobjects.rendering.Responses;
import org.apache.causeway.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.causeway.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.causeway.viewer.restfulobjects.rendering.util.RequestParams;
import org.apache.causeway.viewer.restfulobjects.viewer.context.ResourceContext;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.InteractionFailureHandler;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.JsonParserHelper;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.ObjectAdapterUpdateHelper;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.ResourceAbstract;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.ResourceDescriptor;
import org.apache.causeway.viewer.restfulobjects.viewer.resources._DomainResourceHelper;
import org.apache.causeway.viewer.restfulobjects.viewer.resources._EndpointLogging;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.serialization.SerializationStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NonNull;
import org.springframework.stereotype.Component;

@Component
@Path(value="/objects")
public class DomainObjectResourceServerside
extends ResourceAbstract
implements DomainObjectResource {
    @Generated
    private static final Logger log = LogManager.getLogger(DomainObjectResourceServerside.class);

    public DomainObjectResourceServerside() {
        log.debug("<init>");
    }

    @POST
    @Path(value="/{domainType}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response persist(@PathParam(value="domainType") String domainType, InputStream object) {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.DOMAIN_OBJECT, Where.OBJECT_FORMS, RepresentationService.Intent.JUST_CREATED);
        JsonRepresentation objectRepr = RequestParams.ofRequestBody((InputStream)object).asMap();
        if (!objectRepr.isMap()) {
            throw _EndpointLogging.error(log, "POST /objects/{}", domainType, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Body is not a map; got %s", (Object[])new Object[]{objectRepr}));
        }
        ObjectSpecification domainTypeSpec = this.getSpecificationLoader().specForLogicalTypeName(domainType).orElse(null);
        if (domainTypeSpec == null) {
            throw _EndpointLogging.error(log, "POST /objects/{}", domainType, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Could not determine type of domain object to persist (no class with domainType Id of '%s')", (Object[])new Object[]{domainType}));
        }
        ManagedObject adapter = domainTypeSpec.createObject();
        ObjectAdapterUpdateHelper updateHelper = new ObjectAdapterUpdateHelper(resourceContext, adapter);
        JsonRepresentation membersMap = objectRepr.getMap("members");
        if (membersMap == null) {
            throw _EndpointLogging.error(log, "POST /objects/{}", domainType, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Could not find members map; got %s", (Object[])new Object[]{objectRepr}));
        }
        if (!updateHelper.copyOverProperties(membersMap, ObjectAdapterUpdateHelper.Intent.PERSISTING_NEW)) {
            throw _EndpointLogging.error(log, "POST /objects/{}", domainType, RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)objectRepr, (String)"Illegal property value", (Object[])new Object[0]));
        }
        Consent validity = adapter.objSpec().isValid(adapter, InteractionInitiatedBy.USER);
        if (validity.isVetoed()) {
            throw _EndpointLogging.error(log, "POST /objects/{}", domainType, RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)objectRepr, (String)validity.getReasonAsString().orElse(null), (Object[])new Object[0]));
        }
        MmEntityUtils.persistInCurrentTransaction((ManagedObject)adapter);
        _DomainResourceHelper domainResourceHelper = _DomainResourceHelper.ofObjectResource(resourceContext, adapter);
        return _EndpointLogging.response(log, "POST /objects/{}", domainType, domainResourceHelper.objectRepresentation());
    }

    @GET
    @Path(value="/{domainType}/{instanceId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response object(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId) {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.DOMAIN_OBJECT, Where.OBJECT_FORMS, RepresentationService.Intent.ALREADY_PERSISTENT);
        ManagedObject objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId, roEx -> _EndpointLogging.error(log, "GET /objects/{}/{}", domainType, instanceId, roEx));
        _DomainResourceHelper domainResourceHelper = _DomainResourceHelper.ofObjectResource(resourceContext, objectAdapter);
        return _EndpointLogging.response(log, "GET /objects/{}/{}", domainType, instanceId, domainResourceHelper.objectRepresentation());
    }

    @PUT
    @Path(value="/{domainType}/{instanceId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response object(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, InputStream object) {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.DOMAIN_OBJECT, Where.OBJECT_FORMS, RepresentationService.Intent.ALREADY_PERSISTENT);
        JsonRepresentation argRepr = RequestParams.ofRequestBody((InputStream)object).asMap();
        if (!argRepr.isMap()) {
            throw _EndpointLogging.error(log, "PUT /objects/{}/{}", domainType, instanceId, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Body is not a map; got %s", (Object[])new Object[]{argRepr}));
        }
        ManagedObject objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId, roEx -> _EndpointLogging.error(log, "PUT /objects/{}/{}", domainType, instanceId, roEx));
        ObjectAdapterUpdateHelper updateHelper = new ObjectAdapterUpdateHelper(resourceContext, objectAdapter);
        if (!updateHelper.copyOverProperties(argRepr, ObjectAdapterUpdateHelper.Intent.UPDATE_EXISTING)) {
            throw _EndpointLogging.error(log, "PUT /objects/{}/{}", domainType, instanceId, RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)argRepr, (String)"Illegal property value", (Object[])new Object[0]));
        }
        Consent validity = objectAdapter.objSpec().isValid(objectAdapter, InteractionInitiatedBy.USER);
        if (validity.isVetoed()) {
            throw _EndpointLogging.error(log, "PUT /objects/{}/{}", domainType, instanceId, RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)argRepr, (String)validity.getReasonAsString().orElse(null), (Object[])new Object[0]));
        }
        _DomainResourceHelper domainResourceHelper = _DomainResourceHelper.ofObjectResource(resourceContext, objectAdapter);
        return _EndpointLogging.response(log, "PUT /objects/{}/{}", domainType, instanceId, domainResourceHelper.objectRepresentation());
    }

    @DELETE
    @Path(value="/{domainType}/{instanceId}")
    public Response deleteMethodNotSupported(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId) {
        throw _EndpointLogging.error(log, "DELETE /objects/{}/{}", domainType, instanceId, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting objects is not supported.", (Object[])new Object[0]));
    }

    @POST
    @Path(value="/{domainType}/{instanceId}")
    public Response postMethodNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId) {
        throw _EndpointLogging.error(log, "POST /objects/{}/{}", domainType, instanceId, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to object resource is not allowed.", (Object[])new Object[0]));
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/object-icon")
    @Consumes(value={"*/*"})
    @Produces(value={"image/png", "image/gif", "image/jpeg", "image/jpg", "image/svg+xml"})
    public Response image(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId) {
        ManagedObject objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId, roEx -> _EndpointLogging.error(log, "GET /objects/{}/{}/object-icon", domainType, instanceId, roEx));
        ObjectIcon objectIcon = objectAdapter.getIcon();
        return _EndpointLogging.response(log, "GET /objects/{}/{}/object-icon", domainType, instanceId, Response.ok((Object)objectIcon.asBytes(), (String)objectIcon.getMimeType().getBaseType()).build());
    }

    public Response.ResponseBuilder objectIconResponse(@NonNull ObjectIcon objectIcon) {
        return Response.ok();
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/object-layout")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object-layout-bs\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object-layout-bs\""})
    public Response layout(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId) {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.OBJECT_LAYOUT, Where.ANYWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        SerializationStrategy serializationStrategy = resourceContext.getSerializationStrategy();
        return _EndpointLogging.response(log, "GET({}) /objects/{}/{}/object-layout", serializationStrategy.name(), domainType, instanceId, this.layoutAsGrid(domainType, instanceId).map(grid -> {
            DomainObjectResourceServerside.addLinks(resourceContext, domainType, instanceId, grid);
            return Response.status((Response.Status)Response.Status.OK).entity(serializationStrategy.entity(grid)).type(serializationStrategy.type(RepresentationType.OBJECT_LAYOUT));
        }).orElseGet(Responses::ofNotFound).build());
    }

    private Optional<Grid> layoutAsGrid(String domainType, String instanceId) {
        return this.getSpecificationLoader().specForLogicalTypeName(domainType).flatMap(spec -> Facets.bootstrapGrid((ObjectSpecification)spec, (ManagedObject)this.getObjectAdapterElseThrowNotFound(domainType, instanceId, roEx -> _EndpointLogging.error(log, "GET /objects/{}/{}/object-layout", domainType, instanceId, roEx))));
    }

    public static void addLinks(final ResourceContext resourceContext, final String domainType, final String instanceId, Grid grid) {
        grid.visit((Grid.Visitor)new Grid.VisitorAdapter(){

            public void visit(DomainObjectLayoutData domainObjectLayoutData) {
                Link link = new Link(Rel.ELEMENT.getName(), "GET", resourceContext.restfulUrlFor("objects/" + domainType + "/" + instanceId), RepresentationType.DOMAIN_OBJECT.getJsonMediaType().toString());
                domainObjectLayoutData.setLink(link);
            }

            public void visit(ActionLayoutData actionLayoutData) {
                Link link = new Link(Rel.ACTION.getName(), "GET", resourceContext.restfulUrlFor("objects/" + domainType + "/" + instanceId + "/actions/" + actionLayoutData.getId()), RepresentationType.OBJECT_ACTION.getJsonMediaType().toString());
                actionLayoutData.setLink(link);
            }

            public void visit(PropertyLayoutData propertyLayoutData) {
                Link link = new Link(Rel.PROPERTY.getName(), "GET", resourceContext.restfulUrlFor("objects/" + domainType + "/" + instanceId + "/properties/" + propertyLayoutData.getId()), RepresentationType.OBJECT_PROPERTY.getJsonMediaType().toString());
                propertyLayoutData.setLink(link);
            }

            public void visit(CollectionLayoutData collectionLayoutData) {
                Link link = new Link(Rel.COLLECTION.getName(), "GET", resourceContext.restfulUrlFor("objects/" + domainType + "/" + instanceId + "/collections/" + collectionLayoutData.getId()), RepresentationType.OBJECT_COLLECTION.getJsonMediaType().toString());
                collectionLayoutData.setLink(link);
            }
        });
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object-property\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object-property\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response propertyDetails(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="propertyId") String propertyId) {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.OBJECT_PROPERTY, Where.OBJECT_FORMS, RepresentationService.Intent.NOT_APPLICABLE);
        ManagedObject objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId, roEx -> _EndpointLogging.error(log, "GET /objects/{}/{}/properties/{}", domainType, instanceId, propertyId, roEx));
        return _EndpointLogging.response(log, "GET /objects/{}/{}/properties/{}", domainType, instanceId, propertyId, _DomainResourceHelper.ofObjectResource(resourceContext, objectAdapter).propertyDetails(propertyId, ManagedMember.RepresentationMode.READ));
    }

    @PUT
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object-property\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object-property\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response modifyProperty(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="propertyId") String propertyId, InputStream body) {
        ResourceContext resourceContext = this.createResourceContext(ResourceDescriptor.generic(Where.OBJECT_FORMS, RepresentationService.Intent.NOT_APPLICABLE));
        ManagedObject objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId, roEx -> _EndpointLogging.error(log, "PUT /objects/{}/{}/properties/{}", domainType, instanceId, propertyId, roEx));
        ((PropertyInteraction)((PropertyInteraction)PropertyInteraction.start((ManagedObject)objectAdapter, (String)propertyId, (Where)resourceContext.getWhere()).checkVisibility()).checkUsability(MemberInteraction.AccessIntent.MUTATE)).modifyProperty(property -> {
            ManagedObject proposedNewValue = new JsonParserHelper(resourceContext, property.getElementType()).parseAsMapWithSingleValue(RequestParams.ofRequestBody((InputStream)body));
            return proposedNewValue;
        }).validateElseThrow(veto -> _EndpointLogging.error(log, "PUT /objects/{}/{}/properties/{}", domainType, instanceId, propertyId, InteractionFailureHandler.onFailure(veto)));
        return _EndpointLogging.response(log, "PUT /objects/{}/{}/properties/{}", domainType, instanceId, propertyId, _DomainResourceHelper.ofObjectResource(resourceContext, objectAdapter).propertyDetails(propertyId, ManagedMember.RepresentationMode.WRITE));
    }

    @DELETE
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object-property\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object-property\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response clearProperty(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="propertyId") String propertyId) {
        ResourceContext resourceContext = this.createResourceContext(ResourceDescriptor.generic(Where.OBJECT_FORMS, RepresentationService.Intent.NOT_APPLICABLE));
        ManagedObject objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId, roEx -> _EndpointLogging.error(log, "DELETE /objects/{}/{}/properties/{}", domainType, instanceId, propertyId, roEx));
        ((PropertyInteraction)((PropertyInteraction)PropertyInteraction.start((ManagedObject)objectAdapter, (String)propertyId, (Where)resourceContext.getWhere()).checkVisibility()).checkUsability(MemberInteraction.AccessIntent.MUTATE)).modifyProperty(property -> null).validateElseThrow(veto -> _EndpointLogging.error(log, "DELETE /objects/{}/{}/properties/{}", domainType, instanceId, propertyId, InteractionFailureHandler.onFailure(veto)));
        return _EndpointLogging.response(log, "DELETE /objects/{}/{}/properties/{}", domainType, instanceId, propertyId, _DomainResourceHelper.ofObjectResource(resourceContext, objectAdapter).propertyDetails(propertyId, ManagedMember.RepresentationMode.WRITE));
    }

    @POST
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    public Response postPropertyNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="propertyId") String propertyId) {
        throw _EndpointLogging.error(log, "POST /objects/{}/{}/properties/{}", domainType, instanceId, propertyId, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to a property resource is not allowed.", (Object[])new Object[0]));
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object-collection\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object-collection\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response accessCollection(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="collectionId") String collectionId) {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.OBJECT_COLLECTION, Where.PARENTED_TABLES, RepresentationService.Intent.NOT_APPLICABLE);
        ManagedObject objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId, roEx -> _EndpointLogging.error(log, "GET /objects/{}/{}/collections/{}", domainType, instanceId, collectionId, roEx));
        _DomainResourceHelper domainResourceHelper = _DomainResourceHelper.ofObjectResource(resourceContext, objectAdapter);
        return _EndpointLogging.response(log, "GET /objects/{}/{}/collections/{}", domainType, instanceId, collectionId, domainResourceHelper.collectionDetails(collectionId, ManagedMember.RepresentationMode.READ));
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object-action\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object-action\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response actionPrompt(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId) {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.OBJECT_ACTION, Where.OBJECT_FORMS, RepresentationService.Intent.NOT_APPLICABLE);
        ManagedObject objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId, roEx -> _EndpointLogging.error(log, "GET /objects/{}/{}/actions/{}", domainType, instanceId, actionId, roEx));
        _DomainResourceHelper domainResourceHelper = _DomainResourceHelper.ofObjectResource(resourceContext, objectAdapter);
        return _EndpointLogging.response(log, "GET /objects/{}/{}/actions/{}", domainType, instanceId, actionId, domainResourceHelper.actionPrompt(actionId));
    }

    @DELETE
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}")
    public Response deleteActionPromptNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId) {
        throw _EndpointLogging.error(log, "DELETE /objects/{}/{}/actions/{}", domainType, instanceId, actionId, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting action prompt resource is not allowed.", (Object[])new Object[0]));
    }

    @POST
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}")
    public Response postActionPromptNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId) {
        throw _EndpointLogging.error(log, "POST /objects/{}/{}/actions/{}", domainType, instanceId, actionId, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to an action prompt resource is not allowed.", (Object[])new Object[0]));
    }

    @PUT
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}")
    public Response putActionPromptNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId) {
        throw _EndpointLogging.error(log, "PUT /objects/{}/{}/actions/{}", domainType, instanceId, actionId, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to an action prompt resource is not allowed.", (Object[])new Object[0]));
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response invokeActionQueryOnly(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId, @QueryParam(value="x-causeway-querystring") String xCausewayUrlEncodedQueryString) {
        String urlUnencodedQueryString = UrlUtils.urlDecodeUtf8((String)(xCausewayUrlEncodedQueryString != null ? xCausewayUrlEncodedQueryString : this.httpServletRequest.getQueryString()));
        ResourceContext resourceContext = this.createResourceContext(new ResourceDescriptor(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, RepresentationService.Intent.NOT_APPLICABLE), RequestParams.ofQueryString((String)urlUnencodedQueryString));
        JsonRepresentation arguments = resourceContext.getQueryStringAsJsonRepr();
        ManagedObject objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId, roEx -> _EndpointLogging.error(log, "GET /objects/{}/{}/actions/{}/invoke", domainType, instanceId, actionId, roEx));
        _DomainResourceHelper domainResourceHelper = _DomainResourceHelper.ofObjectResource(resourceContext, objectAdapter);
        return _EndpointLogging.response(log, "GET /objects/{}/{}/actions/{}/invoke", domainType, instanceId, actionId, domainResourceHelper.invokeActionQueryOnly(actionId, arguments));
    }

    @PUT
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response invokeActionIdempotent(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId, InputStream body) {
        ResourceContext resourceContext = this.createResourceContext(new ResourceDescriptor(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, RepresentationService.Intent.NOT_APPLICABLE), body);
        JsonRepresentation arguments = resourceContext.getQueryStringAsJsonRepr();
        ManagedObject objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId, roEx -> _EndpointLogging.error(log, "PUT /objects/{}/{}/actions/{}/invoke", domainType, instanceId, actionId, roEx));
        _DomainResourceHelper domainResourceHelper = _DomainResourceHelper.ofObjectResource(resourceContext, objectAdapter);
        return _EndpointLogging.response(log, "PUT /objects/{}/{}/actions/{}/invoke", domainType, instanceId, actionId, domainResourceHelper.invokeActionIdempotent(actionId, arguments));
    }

    @POST
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response invokeAction(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId, InputStream body) {
        ResourceContext resourceContext = this.createResourceContext(new ResourceDescriptor(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, RepresentationService.Intent.NOT_APPLICABLE), body);
        JsonRepresentation arguments = resourceContext.getQueryStringAsJsonRepr();
        ManagedObject objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId, roEx -> _EndpointLogging.error(log, "POST /objects/{}/{}/actions/{}/invoke", domainType, instanceId, actionId, roEx));
        _DomainResourceHelper domainResourceHelper = _DomainResourceHelper.ofObjectResource(resourceContext, objectAdapter);
        return _EndpointLogging.response(log, "POST /objects/{}/{}/actions/{}/invoke", domainType, instanceId, actionId, domainResourceHelper.invokeAction(actionId, arguments));
    }

    @DELETE
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    public Response deleteInvokeActionNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId) {
        throw _EndpointLogging.error(log, "DELETE /objects/{}/{}/actions/{}/invoke", domainType, instanceId, actionId, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting an action invocation resource is not allowed.", (Object[])new Object[0]));
    }
}

