/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.resources;

import org.apache.causeway.core.metamodel.interactions.managed.InteractionVeto;
import org.apache.causeway.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.causeway.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class InteractionFailureHandler {
    public static RestfulObjectsApplicationException onFailure(@Nullable InteractionVeto veto) {
        if (veto == null) {
            return RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.INTERNAL_SERVER_ERROR, (String)"unexpected empty failure holder", (Object[])new Object[0]);
        }
        switch (veto.vetoType()) {
            case NOT_FOUND: 
            case HIDDEN: {
                return RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND, (String)veto.getReasonAsString().orElse(null), (Object[])new Object[0]);
            }
            case READONLY: 
            case INVALID: {
                return RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.FORBIDDEN, (String)veto.getReasonAsString().orElse(null), (Object[])new Object[0]);
            }
            case ACTION_NOT_SAFE: 
            case ACTION_NOT_IDEMPOTENT: {
                return RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)veto.getReasonAsString().orElse(null), (Object[])new Object[0]);
            }
            case ACTION_PARAM_INVALID: {
                return RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.VALIDATION_FAILED, (String)veto.getReasonAsString().orElse(null), (Object[])new Object[0]);
            }
        }
        return RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.INTERNAL_SERVER_ERROR, (String)("unmatched veto type " + String.valueOf(veto.vetoType())), (Object[])new Object[0]);
    }

    public static RestfulObjectsApplicationException onParameterListInvalid(@NonNull InteractionVeto veto, @NonNull JsonRepresentation arguments) {
        if (veto != null) {
            arguments.mapPutString("x-ro-invalidReason", (String)veto.getReasonAsString().orElse(null));
        }
        return RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.VALIDATION_FAILED, (JsonRepresentation)arguments, (String)"Validation failed, see body for details", (Object[])new Object[0]);
    }

    public static void collectParameterInvalid(@NonNull ObjectActionParameter paramMeta, @NonNull InteractionVeto veto, @NonNull JsonRepresentation arguments) {
        String paramId = paramMeta.getId();
        JsonRepresentation argRepr = arguments.getRepresentation(paramId, new Object[0]);
        argRepr.mapPutString("invalidReason", (String)veto.getReasonAsString().orElse(null));
    }
}

