/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.resources;

import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.Rel;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.causeway.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.HomePageReprRenderer;
import org.springframework.boot.info.BuildProperties;

public class VersionReprRenderer
extends ReprRendererAbstract<Void> {
    VersionReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.VERSION, representation);
    }

    public VersionReprRenderer with(Void t) {
        return this;
    }

    public JsonRepresentation render() {
        if (this.includesSelf) {
            this.addLinkToSelf();
            this.addLinkToUp();
        }
        this.representation.mapPutString("specVersion", "1.0.0");
        this.representation.mapPutString("implVersion", this.getResourceContext().getConfiguration().getBuildProperties().map(BuildProperties::getVersion).orElse("UNKNOWN"));
        this.putOptionalCapabilities();
        this.putExtensions();
        return this.representation;
    }

    private void addLinkToSelf() {
        JsonRepresentation link = LinkBuilder.newBuilder((IResourceContext)this.getResourceContext(), (String)Rel.SELF.getName(), (RepresentationType)RepresentationType.VERSION, (String)"version", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            VersionReprRenderer renderer = new VersionReprRenderer(this.getResourceContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            link.mapPutJsonRepresentation("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToUp() {
        JsonRepresentation link = LinkBuilder.newBuilder((IResourceContext)this.resourceContext, (String)Rel.UP.getName(), (RepresentationType)RepresentationType.HOME_PAGE, (String)"", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            HomePageReprRenderer renderer = new HomePageReprRenderer(this.getResourceContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            link.mapPutJsonRepresentation("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void putOptionalCapabilities() {
        JsonRepresentation optionalCapabilities = JsonRepresentation.newMap((String[])new String[0]);
        optionalCapabilities.mapPutString("blobsClobs", "yes");
        optionalCapabilities.mapPutString("deleteObjects", "yes");
        optionalCapabilities.mapPutString("domainModel", "formal");
        optionalCapabilities.mapPutString("validateOnly", "yes");
        optionalCapabilities.mapPutString("protoPersistentObjects", "yes");
        this.representation.mapPutJsonRepresentation("optionalCapabilities", optionalCapabilities);
    }

    private void putExtensions() {
        this.representation.mapPutJsonRepresentation("extensions", JsonRepresentation.newMap((String[])new String[0]));
    }
}

