/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.resources;

import org.apache.causeway.commons.internal.base._Refs;
import org.apache.causeway.core.metamodel.consent.Consent;
import org.apache.causeway.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.MixedIn;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.viewer.context.ResourceContext;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.JsonParserHelper;

public class ObjectAdapterUpdateHelper {
    private final ManagedObject objectAdapter;
    private final ResourceContext resourceContext;

    public ObjectAdapterUpdateHelper(ResourceContext resourceContext, ManagedObject objectAdapter) {
        this.objectAdapter = objectAdapter;
        this.resourceContext = resourceContext;
    }

    boolean copyOverProperties(JsonRepresentation propertiesMap, Intent intent) {
        _Refs.BooleanReference allOk = _Refs.booleanRef((boolean)true);
        this.objectAdapter.objSpec().streamAssociations(MixedIn.EXCLUDED).filter(ObjectAssociation.Predicates.PROPERTIES).forEach(association -> allOk.update(ok -> ok &= this.copyOverProperty((ObjectAssociation)association, propertiesMap, intent)));
        return allOk.isTrue();
    }

    private boolean copyOverProperty(ObjectAssociation association, JsonRepresentation propertiesMap, Intent intent) {
        ManagedObject valueAdapter;
        boolean valueProvided;
        boolean allOk = true;
        OneToOneAssociation property = (OneToOneAssociation)association;
        ObjectSpecification propertySpec = property.getElementType();
        String id = property.getId();
        JsonRepresentation propertyRepr = propertiesMap.getRepresentation(id, new Object[0]);
        Consent visibility = property.isVisible(this.objectAdapter, this.resourceContext.getInteractionInitiatedBy(), this.resourceContext.getWhere());
        Consent usability = property.isUsable(this.objectAdapter, this.resourceContext.getInteractionInitiatedBy(), this.resourceContext.getWhere());
        boolean invisible = visibility.isVetoed();
        boolean disabled = usability.isVetoed();
        boolean bl = valueProvided = propertyRepr != null;
        if (!valueProvided) {
            if (intent.shouldValidate() && (invisible || disabled)) {
                return allOk;
            }
            if (!property.isMandatory()) {
                return allOk;
            }
            String invalidReason = propertiesMap.getString("x-ro-invalidReason");
            if (invalidReason != null) {
                propertiesMap.mapPutString("x-ro-invalidReason", invalidReason + "; " + property.getFriendlyName(this.objectAdapter));
            } else {
                propertiesMap.mapPutString("x-ro-invalidReason", "Mandatory field(s) missing: " + property.getFriendlyName(this.objectAdapter));
            }
            allOk = false;
            return allOk;
        }
        if (intent.shouldValidate()) {
            if (invisible) {
                return allOk;
            }
            if (disabled) {
                propertyRepr.mapPutString("invalidReason", (String)usability.getReasonAsString().orElse(null));
                allOk = false;
                return allOk;
            }
        }
        try {
            valueAdapter = new JsonParserHelper(this.resourceContext, propertySpec).objectAdapterFor(propertyRepr);
        }
        catch (IllegalArgumentException ex) {
            propertyRepr.mapPutString("invalidReason", ex.getMessage());
            allOk = false;
            return allOk;
        }
        Consent validity = property.isAssociationValid(this.objectAdapter, valueAdapter, InteractionInitiatedBy.USER);
        if (validity.isAllowed()) {
            try {
                property.set(this.objectAdapter, valueAdapter, this.resourceContext.getInteractionInitiatedBy());
            }
            catch (IllegalArgumentException ex) {
                propertyRepr.mapPutString("invalidReason", ex.getMessage());
                allOk = false;
            }
        } else {
            propertyRepr.mapPutString("invalidReason", (String)validity.getReasonAsString().orElse(null));
            allOk = false;
        }
        return allOk;
    }

    static enum Intent {
        UPDATE_EXISTING,
        PERSISTING_NEW;


        private boolean shouldValidate() {
            return this == UPDATE_EXISTING;
        }
    }
}

