/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.about;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.inject.Provider;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.context._Context;
import org.apache.causeway.viewer.wicket.model.models.ModelAbstract;
import org.apache.causeway.viewer.wicket.ui.components.about.JarManifestAttributes;

public class JarManifestModel
extends ModelAbstract<JarManifestModel> {
    private static final long serialVersionUID = 1L;
    private final List<JarManifestAttributes> manifests = _Lists.newArrayList();

    public JarManifestModel(Provider<InputStream> metaInfManifestProvider) {
        Enumeration<URL> resEnum;
        Manifest manifest;
        try (InputStream metaInfManifestIs2 = (InputStream)metaInfManifestProvider.get();){
            manifest = new Manifest(metaInfManifestIs2);
            this.manifests.add(JarManifestAttributes.jarName("Web archive (war file)"));
            this.manifests.add(JarManifestAttributes.jarUrl(null));
            JarManifestModel.addAttributes(manifest, this.manifests);
        }
        catch (Exception metaInfManifestIs2) {
            // empty catch block
        }
        try {
            resEnum = _Context.getDefaultClassLoader().getResources("META-INF/MANIFEST.MF");
        }
        catch (IOException e) {
            return;
        }
        ArrayList jarManifests = _Lists.newArrayList();
        while (resEnum.hasMoreElements()) {
            URL url = resEnum.nextElement();
            JarManifest jarManifest = new JarManifest(url);
            jarManifests.add(jarManifest);
            try {
                InputStream is = url.openStream();
                try {
                    if (is == null) continue;
                    manifest = new Manifest(is);
                    jarManifest.addAttributesFrom(manifest);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        Collections.sort(jarManifests);
        for (JarManifest jarManifest : jarManifests) {
            jarManifest.addAttributesTo(this.manifests);
        }
    }

    private static JarName asJarName(URL url) {
        String path = url.getPath();
        String strippedPath = JarManifestModel.stripSuffix(path, "/META-INF/MANIFEST.MF");
        strippedPath = JarManifestModel.stripSuffix(strippedPath, "!");
        List parts = _Strings.splitThenStream((String)strippedPath, (String)"/").flatMap(s -> _Strings.splitThenStream((String)s, (String)"\\")).filter(_Strings::isNotEmpty).collect(Collectors.toList());
        Collections.reverse(parts);
        for (String part : parts) {
            if (!part.endsWith(".jar")) continue;
            return new JarName(JarName.Type.JAR, part);
        }
        if (parts.size() >= 3 && ((String)parts.get(0)).equals("classes") && ((String)parts.get(1)).startsWith("target")) {
            return new JarName(JarName.Type.CLASSES, (String)parts.get(2));
        }
        return new JarName(JarName.Type.OTHER, strippedPath);
    }

    public static String stripSuffix(String path, String suffix) {
        int indexOf = path.indexOf(suffix);
        if (indexOf != -1) {
            path = path.substring(0, indexOf);
        }
        return path;
    }

    static void addAttributes(Manifest manifest, List<JarManifestAttributes> attributes) {
        Attributes mainAttribs = manifest.getMainAttributes();
        Set<Map.Entry<Object, Object>> entrySet = mainAttribs.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            JarManifestAttributes attribute = JarManifestAttributes.attribute(entry);
            attributes.add(attribute);
        }
    }

    protected JarManifestModel load() {
        return this;
    }

    public void setObject(JarManifestModel ex) {
    }

    public List<JarManifestAttributes> getDetail() {
        return this.manifests;
    }

    private static class JarManifest
    implements Comparable<JarManifest> {
        private final List<JarManifestAttributes> attributes = _Lists.newArrayList();
        private final URL url;
        private JarName jarName;

        public JarManifest(URL url) {
            this.url = url;
            this.jarName = JarManifestModel.asJarName(url);
        }

        void addAttributesFrom(Manifest manifest) {
            JarManifestModel.addAttributes(manifest, this.attributes);
        }

        void addAttributesTo(List<JarManifestAttributes> manifests) {
            manifests.add(JarManifestAttributes.jarName(this.jarName.name));
            manifests.add(JarManifestAttributes.jarUrl(this.url));
            manifests.addAll(this.attributes);
        }

        @Override
        public int compareTo(JarManifest o) {
            return this.jarName.compareTo(o.jarName);
        }
    }

    static class JarName
    implements Comparable<JarName> {
        Type type;
        String name;

        JarName(Type type, String name) {
            this.type = type;
            this.name = name;
        }

        @Override
        public int compareTo(JarName o) {
            int x = this.type.compareTo(o.type);
            if (x != 0) {
                return x;
            }
            return this.name.compareTo(o.name);
        }

        static enum Type {
            CLASSES,
            JAR,
            OTHER;

        }
    }
}

