/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import org.apache.causeway.applib.annotation.TableDecorator;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.facets.SingleValueFacet;
import org.apache.causeway.core.metamodel.facets.object.tabledec.TableDecoratorFacet;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.core.metamodel.tabular.interactive.DataRow;
import org.apache.causeway.core.metamodel.tabular.interactive.DataTableInteractive;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModelAbstract;
import org.apache.causeway.viewer.wicket.model.models.interaction.coll.DataRowWkt;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;

public class CollectionContentsSortableDataProvider
extends SortableDataProvider<DataRow, String> {
    private static final long serialVersionUID = 1L;
    private final IModel<DataTableInteractive> dataTableModelHolder;

    public CollectionContentsSortableDataProvider(IModel<DataTableInteractive> dataTableModelHolder) {
        this.dataTableModelHolder = dataTableModelHolder instanceof EntityCollectionModelAbstract ? ((EntityCollectionModelAbstract)dataTableModelHolder).delegate() : dataTableModelHolder;
    }

    public boolean isDecoratedWithDataTablesNet() {
        return this.getDataTableModel().getMetaModel().getFacetHolder().lookupFacet(TableDecoratorFacet.class).map(SingleValueFacet::value).map(TableDecorator.DatatablesNet.class::equals).orElse(false);
    }

    public DataTableInteractive getDataTableModel() {
        return (DataTableInteractive)this.dataTableModelHolder.getObject();
    }

    public IModel<DataRow> model(DataRow dataRow) {
        return DataRowWkt.chain(this.dataTableModelHolder, (DataRow)dataRow);
    }

    public long size() {
        return this.getDataTableModel().getElementCount();
    }

    public Iterator<DataRow> iterator(long skip, long limit) {
        Can visibleRows = (Can)this.getDataTableModel().getDataRowsFiltered().getValue();
        return this.sorted((Can<DataRow>)visibleRows).iterator(Math.toIntExact(skip), Math.toIntExact(limit));
    }

    private Can<DataRow> sorted(Can<DataRow> dataRows) {
        SortParam sort = this.getSort();
        OneToOneAssociation sortProperty = this.lookupPropertyFor((SortParam<String>)sort).orElse(null);
        if (sortProperty != null) {
            Comparator objComparator = ManagedObjects.orderingBy((ObjectAssociation)sortProperty, (boolean)sort.isAscending());
            return dataRows.sorted((a, b) -> objComparator.compare(a.getRowElement(), b.getRowElement()));
        }
        return dataRows;
    }

    private Optional<OneToOneAssociation> lookupPropertyFor(SortParam<String> sort) {
        return Optional.ofNullable(sort).map(SortParam::getProperty).flatMap(arg_0 -> ((ObjectSpecification)this.getDataTableModel().getElementType()).getProperty(arg_0));
    }
}

