/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns;

import java.util.Optional;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.GenericColumnAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;

public abstract class AssociationColumnAbstract
extends GenericColumnAbstract {
    private static final long serialVersionUID = 1L;
    protected final EntityCollectionModel.Variant collectionVariant;
    protected final String memberId;
    protected final String parentTypeName;
    protected final String describedAs;

    public AssociationColumnAbstract(EntityCollectionModel.Variant collectionVariant, IModel<String> columnNameModel, String sortProperty, String memberId, String parentTypeName, Optional<String> describedAs) {
        super(columnNameModel, sortProperty);
        this.collectionVariant = collectionVariant;
        this.memberId = memberId;
        this.parentTypeName = parentTypeName;
        this.describedAs = describedAs.orElse(null);
    }

    public final Component getHeader(String componentId) {
        Label label = new Label(componentId, this.getDisplayModel());
        label.setEscapeModelStrings(true);
        if (this.describedAs != null) {
            WktTooltips.addTooltip(label, this.describedAs);
        }
        return label;
    }

    public final String getCssClass() {
        String cssClass = super.getCssClass();
        return (String)(_Strings.isNotEmpty((CharSequence)cssClass) ? cssClass + " " : "") + Wkt.cssNormalize("causeway-" + this.parentTypeName + "-" + this.memberId);
    }
}

