/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.widgets.breadcrumbs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.wicket.model.mementos.PageParameterNames;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModel;
import org.apache.causeway.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModelProvider;
import org.apache.causeway.viewer.wicket.ui.errors.JGrowlUtil;
import org.apache.causeway.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Response;
import org.wicketstuff.select2.Select2Choice;
import org.wicketstuff.select2.Settings;

public class BreadcrumbPanel
extends PanelAbstract<Void, IModel<Void>> {
    private static final long serialVersionUID = 1L;
    private static final String ID_BREADCRUMBS = "breadcrumbs";

    public BreadcrumbPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        final BreadcrumbModel breadcrumbModel = _Casts.castTo(BreadcrumbModelProvider.class, (Object)this.getSession()).map(BreadcrumbModelProvider::getBreadcrumbModel).orElseGet(() -> new BreadcrumbModel());
        Model entityModel = new Model();
        ChoiceProvider<UiObjectWkt> choiceProvider = new ChoiceProvider<UiObjectWkt>(){
            private static final long serialVersionUID = 1L;

            public String getDisplayValue(UiObjectWkt choice) {
                return this.titleFor(choice);
            }

            private String titleFor(UiObjectWkt model) {
                return model.getManagedObject().getTitle();
            }

            public String getIdValue(UiObjectWkt choice) {
                try {
                    PageParameters pageParameters = choice.getPageParametersWithoutUiHints();
                    String oidStr = PageParameterNames.OBJECT_OID.getStringFrom(pageParameters);
                    return Bookmark.parse((String)oidStr).map(Bookmark::stringify).orElseGet(() -> {
                        breadcrumbModel.remove(choice);
                        return null;
                    });
                }
                catch (Exception ex) {
                    breadcrumbModel.remove(choice);
                    return null;
                }
            }

            public void query(String term, int page, Response<UiObjectWkt> response) {
                ArrayList breadCrumbList = _Lists.newArrayList(breadcrumbModel.getList());
                List checkedList = _Lists.filter((Collection)breadCrumbList, input -> {
                    String id = this.getIdValue((UiObjectWkt)input);
                    return id != null;
                });
                response.addAll((Collection)checkedList);
            }

            public Collection<UiObjectWkt> toChoices(Collection<String> ids) {
                return breadcrumbModel.getList();
            }
        };
        final Select2Choice breadcrumbChoice = new Select2Choice(ID_BREADCRUMBS, (IModel)entityModel, (ChoiceProvider)choiceProvider);
        breadcrumbChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                String oidStr = breadcrumbChoice.getInput();
                UiObjectWkt selectedModel = breadcrumbModel.lookup(oidStr);
                if (selectedModel == null) {
                    CausewayConfiguration configuration = this.getMetaModelContext().getConfiguration();
                    this.getMetaModelContext().getMessageBroker().ifPresent(messageBroker -> {
                        messageBroker.addWarning("Cannot find object");
                        String feedbackMsg = JGrowlUtil.asJGrowlCalls(messageBroker, configuration);
                        target.appendJavaScript((CharSequence)feedbackMsg);
                    });
                    breadcrumbModel.remove(oidStr);
                    return;
                }
                BreadcrumbPanel.this.setResponsePage(EntityPage.class, selectedModel.getPageParametersWithoutUiHints());
            }

            private MetaModelContext getMetaModelContext() {
                return BreadcrumbPanel.this.getMetaModelContext();
            }
        }});
        Settings settings = breadcrumbChoice.getSettings();
        settings.setMinimumInputLength(Integer.valueOf(0));
        settings.setWidth("100%");
        this.addOrReplace(new Component[]{breadcrumbChoice});
    }

    protected void onConfigure() {
        super.onConfigure();
        boolean shouldShow = this.getWicketViewerSettings().getBookmarkedPages().isShowDropDownOnFooter();
        this.setVisible(shouldShow);
    }
}

