/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.pages.accmngt.register;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import javax.inject.Inject;
import org.apache.causeway.applib.services.userreg.UserDetails;
import org.apache.causeway.viewer.wicket.model.models.PageType;
import org.apache.causeway.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.causeway.viewer.wicket.ui.pages.PageNavigationService;
import org.apache.causeway.viewer.wicket.ui.pages.accmngt.AccountConfirmationMap;
import org.apache.causeway.viewer.wicket.ui.pages.accmngt.AccountManagementPageAbstract;
import org.apache.causeway.viewer.wicket.ui.pages.accmngt.register.RegisterPanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;

public class RegisterPage
extends AccountManagementPageAbstract {
    private static final long serialVersionUID = 1L;
    @Inject
    private PageNavigationService pageNavigationService;

    public RegisterPage(PageParameters parameters) {
        this(parameters, RegisterPage.getAndClearExceptionModelIfAny());
    }

    private RegisterPage(PageParameters parameters, ExceptionModel exceptionModel) {
        super(parameters, exceptionModel);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new NotificationPanel("feedback")});
        StringValue uuidValue = this.getPageParameters().get(0);
        if (uuidValue.isEmpty()) {
            this.pageNavigationService.navigateTo(PageType.SIGN_IN);
        } else {
            String uuid = uuidValue.toString();
            AccountConfirmationMap accountConfirmationMap = (AccountConfirmationMap)((Object)this.getApplication().getMetaData(AccountConfirmationMap.KEY));
            String email = accountConfirmationMap.get(uuid);
            if (Strings.isEmpty((String)email)) {
                this.pageNavigationService.navigateTo(PageType.SIGN_IN);
            } else {
                UserDetails userDetails = this.newUserDetails();
                this.addOrReplace(new Component[]{new RegisterPanel("content", userDetails, uuidValue.toString()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected MarkupContainer newExtraFieldsContainer(String id) {
                        return RegisterPage.this.newExtraFieldsContainer(id);
                    }
                }});
            }
        }
    }

    protected UserDetails newUserDetails() {
        return new UserDetails();
    }

    protected MarkupContainer newExtraFieldsContainer(String id) {
        return new WebMarkupContainer(id);
    }
}

