/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.util;

import de.agilecoders.wicket.jquery.util.Strings2;
import java.util.Optional;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.util.lang.Args;
import org.springframework.lang.Nullable;

public final class WktComponents {
    public static Optional<Component> findById(@Nullable MarkupContainer container, @Nullable String id) {
        if (container == null || _Strings.isNullOrEmpty((CharSequence)id)) {
            return Optional.empty();
        }
        return container.streamChildren().filter(child -> id.equals(child.getId())).findFirst();
    }

    public static <T extends Component> Optional<T> findById(@Nullable MarkupContainer container, @Nullable String id, @NonNull Class<T> requiredType) {
        if (requiredType == null) {
            throw new NullPointerException("requiredType is marked non-null but is null");
        }
        return WktComponents.findById(container, id).filter(requiredType::isInstance).map(requiredType::cast);
    }

    public static void permanentlyHide(MarkupContainer container, String ... ids) {
        for (String id : ids) {
            WktComponents.permanentlyHideSingle(container, id);
        }
    }

    public static void permanentlyHide(MarkupContainer container, UiComponentType ... componentIds) {
        for (UiComponentType uiComponentType : componentIds) {
            WktComponents.permanentlyHideSingle(container, uiComponentType.getId());
        }
    }

    private static void permanentlyHideSingle(MarkupContainer container, String id) {
        WebMarkupContainer invisible = new WebMarkupContainer(id);
        invisible.setVisible(false);
        container.addOrReplace(new Component[]{invisible});
    }

    public static void setVisible(MarkupContainer container, boolean visibility, String ... ids) {
        for (String id : ids) {
            WktComponents.setVisible(container, visibility, id);
        }
    }

    public static void setVisible(MarkupContainer container, boolean visibility, UiComponentType ... componentTypes) {
        for (UiComponentType uiComponentType : componentTypes) {
            WktComponents.setVisible(container, visibility, uiComponentType.getId());
        }
    }

    private static void setVisible(MarkupContainer container, boolean visibility, String wicketId) {
        Component childComponent = container.get(wicketId);
        childComponent.setVisible(visibility);
    }

    public static boolean isRenderedComponent(Component component) {
        return component.getOutputMarkupId() && !(component instanceof Page);
    }

    public static boolean hasPage(Component component) {
        return component.findParent(Page.class) != null;
    }

    public static void addToAjaxRequest(AjaxRequestTarget target, Component component) {
        if (target == null || component == null) {
            return;
        }
        try {
            target.add(new Component[]{component});
        }
        catch (IllegalArgumentException cause) {
            _Exceptions.FluentException.of((Exception)cause).suppressIfMessageContains("Cannot update component because its page is not the same");
        }
    }

    public static CharSequence getMarkupId(Component component) {
        return Strings2.getMarkupId((Component)((Component)Args.notNull((Object)component, (String)"component")));
    }

    private WktComponents() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

