/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.io.TextUtils;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public final class WktHeaderItems {
    public static OnDomReadyHeaderItem forScriptReferenceAsOnDomReady(@NonNull Class<?> resourceLocation, @NonNull String resourceName) {
        if (resourceLocation == null) {
            throw new NullPointerException("resourceLocation is marked non-null but is null");
        }
        if (resourceName == null) {
            throw new NullPointerException("resourceName is marked non-null but is null");
        }
        return OnDomReadyHeaderItem.forScript((CharSequence)WktHeaderItems.readJsResource(resourceLocation, resourceName));
    }

    public static JavaScriptReferenceHeaderItem forScriptReference(@NonNull Class<?> resourceLocation, @NonNull String resourceName) {
        if (resourceLocation == null) {
            throw new NullPointerException("resourceLocation is marked non-null but is null");
        }
        if (resourceName == null) {
            throw new NullPointerException("resourceName is marked non-null but is null");
        }
        return JavaScriptReferenceHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(resourceLocation, resourceName));
    }

    public static CssReferenceHeaderItem forCssReference(@NonNull Class<?> resourceLocation, @NonNull String resourceName) {
        if (resourceLocation == null) {
            throw new NullPointerException("resourceLocation is marked non-null but is null");
        }
        if (resourceName == null) {
            throw new NullPointerException("resourceName is marked non-null but is null");
        }
        return CssHeaderItem.forReference((ResourceReference)new CssResourceReference(resourceLocation, resourceName));
    }

    private static String readJsResource(@NonNull Class<?> resourceLocation, @NonNull String resourceName) {
        if (resourceLocation == null) {
            throw new NullPointerException("resourceLocation is marked non-null but is null");
        }
        if (resourceName == null) {
            throw new NullPointerException("resourceName is marked non-null but is null");
        }
        return TextUtils.readLinesFromResource(resourceLocation, (String)resourceName, (Charset)StandardCharsets.UTF_8).filter(_Strings::isNotEmpty).filter(line -> !line.trim().startsWith("//")).stream().skip(18L).collect(Collectors.joining("\n"));
    }

    private WktHeaderItems() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class HeaderContributor
    implements IHeaderContributor {
        private static final long serialVersionUID = 1L;
        private final HeaderItem headerItem;

        public void renderHead(IHeaderResponse response) {
            response.render(this.headerItem);
        }

        public HeaderContributor(HeaderItem headerItem) {
            this.headerItem = headerItem;
        }

        public HeaderItem getHeaderItem() {
            return this.headerItem;
        }
    }
}

