/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.app.registry;

import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;

public interface ComponentFactoryRegistrar {
    public void addComponentFactories(ComponentFactoryList var1);

    public static class ComponentFactoryList
    implements Iterable<ComponentFactory> {
        private final List<ComponentFactory> componentFactories = _Lists.newArrayList();

        public void add(ComponentFactory componentFactory) {
            if (this.componentFactories.contains(componentFactory)) {
                return;
            }
            this.componentFactories.add(componentFactory);
        }

        public void replace(ComponentFactory replacementComponentFactory) {
            this.removeExisting(ComponentFactoryList.matching(replacementComponentFactory.getComponentType()));
            this.add(replacementComponentFactory);
        }

        public void replace(Class<? extends ComponentFactory> toReplace, ComponentFactory replacementComponentFactory) {
            int indexOfOldFactory = this.removeExisting(ComponentFactoryList.matching(toReplace));
            this.insert(indexOfOldFactory, replacementComponentFactory);
        }

        private void insert(int indexToInsertInto, ComponentFactory replacementComponentFactory) {
            if (indexToInsertInto > -1 && indexToInsertInto < this.componentFactories.size()) {
                this.componentFactories.add(indexToInsertInto, replacementComponentFactory);
            } else {
                this.componentFactories.add(replacementComponentFactory);
            }
        }

        private int removeExisting(Predicate<ComponentFactory> predicate) {
            int indexOfFirst = -1;
            for (int i = 0; i < this.componentFactories.size(); ++i) {
                ComponentFactory factory = this.componentFactories.get(i);
                if (!predicate.test(factory)) continue;
                this.componentFactories.remove(i);
                if (indexOfFirst == -1) {
                    indexOfFirst = i;
                }
                --i;
            }
            return indexOfFirst;
        }

        private static Predicate<ComponentFactory> matching(final UiComponentType uiComponentType) {
            return new Predicate<ComponentFactory>(){

                @Override
                public boolean test(ComponentFactory input) {
                    return input.getComponentType() == uiComponentType;
                }
            };
        }

        private static Predicate<ComponentFactory> matching(final Class<? extends ComponentFactory> toReplace) {
            return new Predicate<ComponentFactory>(){

                @Override
                public boolean test(ComponentFactory input) {
                    return toReplace.isAssignableFrom(input.getClass());
                }
            };
        }

        @Override
        public Iterator<ComponentFactory> iterator() {
            return this.componentFactories.iterator();
        }

        public Stream<ComponentFactory> stream() {
            return this.componentFactories.stream();
        }

        public <T extends ComponentFactory> Stream<T> stream(Class<T> requiredClass) {
            return this.stream().filter(requiredClass::isInstance).map(requiredClass::cast);
        }
    }
}

