/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.scalars;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.BootstrapFileInputField;
import java.io.Serializable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.services.placeholder.PlaceholderRenderService;
import org.apache.causeway.commons.internal.functions._Functions;
import org.apache.causeway.core.metamodel.interactions.managed.InteractionVeto;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedValue;
import org.apache.causeway.viewer.commons.model.components.UiString;
import org.apache.causeway.viewer.wicket.model.models.FormExecutorContext;
import org.apache.causeway.viewer.wicket.model.models.InlinePromptContext;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarPanelAdditionalButton;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarPanelFormFieldAbstract;
import org.apache.causeway.viewer.wicket.ui.components.scalars._Util;
import org.apache.causeway.viewer.wicket.ui.components.widgets.links.AjaxLinkNoPropagate;
import org.apache.causeway.viewer.wicket.ui.panels.FormExecutorDefault;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.springframework.lang.Nullable;

public abstract class ScalarPanelAbstract2
extends ScalarPanelAbstract {
    private static final long serialVersionUID = 1L;
    protected MarkupContainer fieldFrame;
    protected WebMarkupContainer inlinePromptLink;

    protected ScalarPanelAbstract2(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    @Override
    protected final void setupInlinePrompt() {
        ScalarModel scalarModel = this.scalarModel();
        MarkupContainer regularFrame = this.getRegularFrame();
        MarkupContainer fieldFrame = this.getFieldFrame();
        WebMarkupContainer scalarFrameContainer = this.getScalarFrameContainer();
        scalarModel.setInlinePromptContext(new InlinePromptContext(scalarModel, (MarkupContainer)scalarFrameContainer, (Component)regularFrame, this.getFormFrame()));
        ScalarFragmentFactory.FieldFragment.matching(fieldFrame).ifPresent(fieldFragment -> {
            switch (fieldFragment) {
                case LINK_TO_PROMT: {
                    Component[] componentArray = new Component[1];
                    this.inlinePromptLink = this.createInlinePromptLink();
                    componentArray[0] = this.inlinePromptLink;
                    fieldFrame.addOrReplace(componentArray);
                    this.addOnClickBehaviorTo((MarkupContainer)this.inlinePromptLink);
                    RepeatingView additionalButtonContainer = fieldFragment.createButtonContainer((MarkupContainer)this.inlinePromptLink);
                    this.addAdditionalButtonsTo(additionalButtonContainer, (ScalarFragmentFactory.FieldFragment)((Object)fieldFragment));
                    return;
                }
                case NO_LINK_VIEWING: 
                case NO_LINK_EDITING: {
                    RepeatingView additionalButtonContainer = fieldFragment.createButtonContainer(fieldFrame);
                    this.addAdditionalButtonsTo(additionalButtonContainer, (ScalarFragmentFactory.FieldFragment)((Object)fieldFragment));
                    return;
                }
            }
        });
        if (fieldFrame != null && fieldFrame.get("scalarValue") == null) {
            Wkt.labelAdd(fieldFrame, "scalarValue", "\u2205");
        }
    }

    protected Component createComponentForOutput(String id) {
        if (this.isUsingTextarea()) {
            return ScalarFragmentFactory.PromptFragment.TEXTAREA.createFragment(id, (MarkupContainer)this, scalarValueId -> {
                TextArea<String> textArea = Wkt.textAreaNoTab(scalarValueId, (IModel<String>)((IModel & Serializable)this::outputFormatAsString));
                ScalarModel scalarModel = this.scalarModel();
                Wkt.setFormComponentAttributes(textArea, () -> ((ScalarModel)scalarModel).multilineNumberOfLines(), () -> ((ScalarModel)scalarModel).maxLength(), () -> ((ScalarModel)scalarModel).typicalLength());
                return textArea;
            });
        }
        return ScalarFragmentFactory.CompactFragment.LABEL.createFragment(id, (MarkupContainer)this, scalarValueId -> Wkt.labelWithDynamicEscaping(scalarValueId, (_Functions.SerializableSupplier<UiString>)((_Functions.SerializableSupplier & Serializable)this::obtainOutputFormat)));
    }

    private boolean isUsingTextarea() {
        if (this.getRenderScenario().isCompact() || this.getFormatModifiers().contains((Enum)ScalarPanelAbstract.FormatModifier.MARKUP) || !this.getFormatModifiers().contains((Enum)ScalarPanelAbstract.FormatModifier.MULTILINE)) {
            return false;
        }
        return !this.scalarModel().isEmpty();
    }

    protected final String outputFormatAsString() {
        return this.obtainOutputFormat().getString();
    }

    protected UiString obtainOutputFormat() {
        ManagedValue proposedValue = this.scalarModel().proposedValue();
        if (!proposedValue.isPresent()) {
            return UiString.markup((String)this.getPlaceholderRenderService().asHtml(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION));
        }
        return this.isUsingTextarea() || this.getFormatModifiers().contains((Enum)ScalarPanelAbstract.FormatModifier.TEXT_ONLY) ? UiString.text((String)((String)proposedValue.getValueAsTitle().getValue())) : UiString.markup((String)((String)proposedValue.getValueAsHtml().getValue()));
    }

    protected void onSwitchFormForInlinePrompt(WebMarkupContainer inlinePromptForm, AjaxRequestTarget target) {
    }

    protected void configureInlinePromptLink(WebMarkupContainer inlinePromptLink) {
        Wkt.cssAppend(inlinePromptLink, this.obtainInlinePromptLinkCssIfAny());
    }

    protected String obtainInlinePromptLinkCssIfAny() {
        return "form-control form-control-sm";
    }

    @Override
    protected void onMakeNotEditable(String disableReason) {
        this.setupInlinePrompt();
    }

    @Override
    protected void onMakeEditable() {
        this.setupInlinePrompt();
    }

    private void addOnClickBehaviorTo(@Nullable MarkupContainer clickReceiver) {
        if (clickReceiver == null) {
            return;
        }
        ScalarModel scalarModel = this.scalarModel();
        if (_Util.canPropertyEnterInlineEditDirectly(scalarModel)) {
            _Util.lookupMixinForCompositeValueUpdate(scalarModel).ifPresentOrElse(mixinForCompositeValueEdit -> Wkt.behaviorAddOnClick((Component)clickReceiver, (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)arg_0 -> ((AjaxLink)mixinForCompositeValueEdit.getUiComponent()).onClick(arg_0))), () -> Wkt.behaviorAddOnClick((Component)clickReceiver, (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)this::onPropertyInlineEditClick)));
        } else {
            _Util.lookupPropertyActionForInlineEdit(scalarModel).ifPresent(actionLinkInlineAsIfEdit -> Wkt.behaviorAddOnClick((Component)clickReceiver, (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)arg_0 -> ((AjaxLink)actionLinkInlineAsIfEdit.getUiComponent()).onClick(arg_0))));
        }
    }

    private void addAdditionalButtonsTo(@NonNull RepeatingView buttonContainer, ScalarFragmentFactory.FieldFragment fieldFragment) {
        if (buttonContainer == null) {
            throw new NullPointerException("buttonContainer is marked non-null but is null");
        }
        block6: for (ScalarPanelAdditionalButton additionalButton : ScalarPanelAdditionalButton.values()) {
            if (!additionalButton.isVisible(this.scalarModel(), this.getRenderScenario(), fieldFragment)) continue;
            switch (additionalButton) {
                case COPY_TO_CLIPBOARD: {
                    continue block6;
                }
                case DISABLED_REASON: {
                    this.addDisabledReasonIcon(buttonContainer, "fa-solid fa-ban veto-reason-icon", "");
                    continue block6;
                }
                case DISABLED_REASON_PROTOTYPING: {
                    this.addDisabledReasonIcon(buttonContainer, "fa-solid fa-text-slash veto-reason-icon prototyping", " Note: This icon only appears in prototyping mode (unless disabled via config option).");
                    continue block6;
                }
                case CLEAR_FIELD: {
                    this.addClearFieldButton(buttonContainer);
                    continue block6;
                }
            }
        }
    }

    private void addDisabledReasonIcon(@NonNull RepeatingView buttonContainer, @NonNull String faClass, @NonNull String reasonSuffix) {
        if (buttonContainer == null) {
            throw new NullPointerException("buttonContainer is marked non-null but is null");
        }
        if (faClass == null) {
            throw new NullPointerException("faClass is marked non-null but is null");
        }
        if (reasonSuffix == null) {
            throw new NullPointerException("reasonSuffix is marked non-null but is null");
        }
        AjaxLinkNoPropagate disableReasonButton = Wkt.linkAddWithBody(buttonContainer, Wkt.faIcon(faClass), (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)ajaxTarget -> {});
        String disabledReason = this.scalarModel().disabledReason().flatMap(InteractionVeto::getReasonAsString).orElse("framework bug: should provide a reason");
        WktTooltips.addTooltip(disableReasonButton, this.translate(disabledReason) + this.translate(reasonSuffix));
        Wkt.noTabbing((Component)disableReasonButton);
        if (this.scalarModel().isParameter()) {
            disableReasonButton.setEventPropagation(AjaxRequestAttributes.EventPropagation.BUBBLE);
        }
    }

    private void addClearFieldButton(@NonNull RepeatingView buttonContainer) {
        if (buttonContainer == null) {
            throw new NullPointerException("buttonContainer is marked non-null but is null");
        }
        AjaxLinkNoPropagate clearFieldButton = Wkt.linkAddWithBody(buttonContainer, Wkt.faIcon("fa-regular fa-trash-can"), (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)this::onClearFieldButtonClick));
        Wkt.cssAppend(clearFieldButton, "btn-warning");
        WktTooltips.addTooltip(clearFieldButton, this.translate("Click to clear the field"));
        if (this.scalarModel().isParameter()) {
            clearFieldButton.setEventPropagation(AjaxRequestAttributes.EventPropagation.BUBBLE);
        }
    }

    private WebMarkupContainer createInlinePromptLink() {
        WebMarkupContainer inlinePromptLink = ScalarFragmentFactory.FieldFrame.SCALAR_VALUE_INLINE_PROMPT_LINK.createComponent(WebMarkupContainer::new);
        inlinePromptLink.setOutputMarkupId(true);
        inlinePromptLink.setOutputMarkupPlaceholderTag(true);
        this.configureInlinePromptLink(inlinePromptLink);
        Wkt.add((MarkupContainer)inlinePromptLink, ScalarFragmentFactory.FieldFrame.SCALAR_VALUE_CONTAINER.createComponent(id -> this.createComponentForOutput((String)id)));
        return inlinePromptLink;
    }

    private void onPropertyInlineEditClick(AjaxRequestTarget target) {
        this.scalarModel().toEditingMode();
        this.switchRegularFrameToFormFrame();
        this.onSwitchFormForInlinePrompt(this.getFormFrame(), target);
        target.add(new Component[]{this.getScalarFrameContainer()});
        Wkt.focusOnMarkerAttribute((MarkupContainer)this.getFormFrame(), target);
        Wkt.javaScriptAdd(target, Wkt.EventTopic.FOCUS_FIRST_PARAMETER, this.getMarkupId());
    }

    private void onClearFieldButtonClick(AjaxRequestTarget target) {
        this.scalarModel().proposedValue().clear();
        this.scalarModel().getSpecialization().accept(param -> {
            this.clearBootstrapFileInputField();
            this.setupInlinePrompt();
            target.add(new Component[]{this});
        }, prop -> FormExecutorDefault.forProperty(prop).executeAndProcessResults(target, null, (FormExecutorContext)prop));
    }

    private void clearBootstrapFileInputField() {
        ScalarPanelFormFieldAbstract formContainer;
        FormComponent formComponent;
        if (this instanceof ScalarPanelFormFieldAbstract && (formComponent = (formContainer = (ScalarPanelFormFieldAbstract)this).getFormComponent()) instanceof BootstrapFileInputField) {
            FormComponent replacement = formContainer.createFormComponent(formComponent.getId(), this.scalarModel());
            formComponent.replaceWith(replacement);
        }
    }

    @Generated
    protected MarkupContainer getFieldFrame() {
        return this.fieldFrame;
    }
}

