/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import java.io.Serializable;
import org.apache.causeway.viewer.wicket.model.models.HasCommonContext;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.TimeTakenModel;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LambdaModel;
import org.apache.wicket.model.Model;
import org.danekja.java.util.function.serializable.SerializableSupplier;

public class CausewayTotalRecordsToolbar
extends AbstractToolbar
implements HasCommonContext {
    private static final long serialVersionUID = 1L;
    private static final String navigatorContainerId = "navigatorContainer";

    public CausewayTotalRecordsToolbar(final DataTable<?, ?> table) {
        this(table, (IModel<String>)new Model<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return String.format("Showing all of %d", table.getRowCount());
            }
        });
    }

    protected CausewayTotalRecordsToolbar(DataTable<?, ?> table, IModel<String> messageModel) {
        super(table);
        WebMarkupContainer container = new WebMarkupContainer(navigatorContainerId);
        this.add(new Component[]{container});
        container.add(new Behavior[]{AttributeModifier.replace((String)"colspan", (IModel)LambdaModel.of((SerializableSupplier & Serializable)() -> String.valueOf(table.getColumns().size()).intern()))});
        Wkt.labelAdd((MarkupContainer)container, "navigatorLabel", messageModel);
        Wkt.labelAdd((MarkupContainer)container, "prototypingLabel", TimeTakenModel.createForPrototypingElseBlank(this.getMetaModelContext()));
    }

    protected void onConfigure() {
        super.onConfigure();
        if (this.getTable().getRowCount() <= 5L) {
            this.setVisible(false);
            return;
        }
        this.setVisible(this.getTable().getPageCount() == 1L);
    }
}

