/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.header;

import org.apache.causeway.viewer.commons.applib.services.branding.BrandingUiModel;
import org.apache.causeway.viewer.commons.applib.services.header.HeaderUiModel;
import org.apache.causeway.viewer.commons.applib.services.menu.model.NavbarSection;
import org.apache.causeway.viewer.commons.applib.services.menu.model.NavbarUiModel;
import org.apache.causeway.viewer.commons.applib.services.userprof.UserProfileUiModel;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.ServiceActionsModel;
import org.apache.causeway.viewer.wicket.ui.components.widgets.navbar.AvatarImage;
import org.apache.causeway.viewer.wicket.ui.components.widgets.navbar.BrandLogo;
import org.apache.causeway.viewer.wicket.ui.components.widgets.navbar.BrandName;
import org.apache.causeway.viewer.wicket.ui.pages.error.ErrorPage;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class HeaderPanel
extends PanelAbstract<String, Model<String>> {
    private static final long serialVersionUID = 1L;
    private static final String ID_USER_NAME = "userName";
    private static final String ID_USER_ICON = "userIcon";
    private static final String ID_USER_AVATAR = "userAvatar";
    private static final String ID_PRIMARY_MENU_BAR = "primaryMenuBar";
    private static final String ID_SECONDARY_MENU_BAR = "secondaryMenuBar";
    private static final String ID_TERTIARY_MENU_BAR = "tertiaryMenuBar";

    public HeaderPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        HeaderUiModel headerUiModel = super.getHeaderModel();
        this.addApplicationName(headerUiModel.branding());
        this.addUserName(headerUiModel.userProfile());
        this.addServiceActionMenuBars(headerUiModel);
    }

    protected void onConfigure() {
        super.onConfigure();
        PageParameters parameters = this.getPage().getPageParameters();
        this.setVisible(parameters.get("causeway.no.header").isNull());
    }

    protected void addApplicationName(BrandingUiModel branding) {
        Class homePage = this.getApplication().getHomePage();
        BookmarkablePageLink applicationNameLink = new BookmarkablePageLink("applicationName", homePage);
        applicationNameLink.add(new Component[]{new BrandName("brandText", branding), new BrandLogo("brandLogo", branding)});
        this.add(new Component[]{applicationNameLink});
    }

    protected void addUserName(final UserProfileUiModel userProfile) {
        this.add(new Component[]{new MarkupContainer(ID_USER_ICON){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(!userProfile.avatarUrl().isPresent());
            }
        }});
        this.add(new Component[]{new AvatarImage(ID_USER_AVATAR, userProfile)});
        Wkt.labelAdd((MarkupContainer)this, ID_USER_NAME, userProfile.getUserProfileName());
    }

    protected void addServiceActionMenuBars(HeaderUiModel headerUiModel) {
        NavbarUiModel navbar = headerUiModel.navbar();
        if (this.getPage() instanceof ErrorPage) {
            WktComponents.permanentlyHide((MarkupContainer)this, ID_PRIMARY_MENU_BAR);
            WktComponents.permanentlyHide((MarkupContainer)this, ID_SECONDARY_MENU_BAR);
            this.addMenuBar(ID_TERTIARY_MENU_BAR, navbar.tertiary());
        } else {
            this.addMenuBar(ID_PRIMARY_MENU_BAR, navbar.primary());
            this.addMenuBar(ID_SECONDARY_MENU_BAR, navbar.secondary());
            this.addMenuBar(ID_TERTIARY_MENU_BAR, navbar.tertiary());
        }
    }

    private void addMenuBar(String id, NavbarSection menuUiModel) {
        HeaderPanel container = this;
        ServiceActionsModel menuModel = new ServiceActionsModel(menuUiModel);
        Component menuBarComponent = this.getComponentFactoryRegistry().createComponent(id, UiComponentType.SERVICE_ACTIONS, (IModel<?>)menuModel);
        Wkt.cssAppend(menuBarComponent, menuUiModel.cssClass());
        container.add(new Component[]{menuBarComponent});
    }
}

