/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.scalars.composite;

import java.util.Optional;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarPanelFormFieldAbstract;
import org.apache.causeway.viewer.wicket.ui.components.scalars.markup.MarkupComponent;
import org.apache.causeway.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;

public class CompositeValuePanel<T>
extends ScalarPanelFormFieldAbstract<T> {
    private static final long serialVersionUID = 1L;

    public CompositeValuePanel(String id, ScalarModel scalarModel, Class<T> valueType) {
        super(id, scalarModel, valueType);
    }

    @Override
    protected Component createComponentForOutput(String id) {
        return new MarkupComponent(id, (IModel<?>)this.scalarModel());
    }

    @Override
    protected Optional<ScalarFragmentFactory.InputFragment> getInputFragmentType() {
        return Optional.empty();
    }

    @Override
    protected void onFormGroupCreated(FormGroup formGroup) {
        super.onFormGroupCreated(formGroup);
        this.fieldFrame.addOrReplace(new Component[]{ScalarFragmentFactory.FieldFrame.SCALAR_VALUE_CONTAINER.createComponent(this::createComponentForOutput)});
    }

    @Override
    protected FormComponent<T> createFormComponent(String id, ScalarModel scalarModel) {
        return new AbstractTextComponent<T>(id){
            private static final long serialVersionUID = 1L;

            public void validate() {
            }

            public boolean checkRequired() {
                if (CompositeValuePanel.this.scalarModel().isRequired()) {
                    return !CompositeValuePanel.this.scalarModel().isEmpty();
                }
                return true;
            }

            public void updateModel() {
            }
        };
    }
}

