/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.text;

import java.util.Optional;
import lombok.NonNull;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.validation.IValidationError;
import org.springframework.lang.Nullable;

public class TextFieldWithConverter<T>
extends TextField<T> {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final IConverter<T> converter;

    public TextFieldWithConverter(@NonNull String id, @NonNull IModel<T> model, @NonNull Class<T> type, @NonNull Optional<IConverter<T>> converter) {
        super(id, model, type);
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (converter == null) {
            throw new NullPointerException("converter is marked non-null but is null");
        }
        this.converter = converter.orElse(null);
    }

    public final <C> IConverter<C> getConverter(Class<C> cType) {
        return this.converter != null && this.getType().isAssignableFrom(cType) ? this.converter : super.getConverter(cType);
    }

    public final void error(IValidationError error) {
        if (!Wkt.errorMessageIgnoringResourceBundles(this, error)) {
            super.error(error);
        }
    }

    public boolean checkRequired() {
        return super.checkRequired();
    }
}

