/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.tree;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.causeway.applib.graph.tree.TreeAdapter;
import org.apache.causeway.applib.graph.tree.TreePath;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.commons.functional.IndexedFunction;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.viewer.wicket.ui.components.tree._TreeNodeMemento;
import org.springframework.lang.Nullable;

class _TreeModelTreeAdapter
implements TreeAdapter<_TreeNodeMemento>,
HasMetaModelContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<? extends TreeAdapter> treeAdapterClass;
    private transient TreeAdapter wrappedTreeAdapter;

    _TreeModelTreeAdapter(Class<? extends TreeAdapter> treeAdapterClass) {
        this.treeAdapterClass = treeAdapterClass;
    }

    public Optional<_TreeNodeMemento> parentOf(_TreeNodeMemento treeModel) {
        if (treeModel == null) {
            return Optional.empty();
        }
        Object pojoNode = this.demementify(treeModel);
        if (pojoNode == null) {
            return Optional.empty();
        }
        return this.wrappedTreeAdapter().parentOf(pojoNode).map(pojo -> this.mementify(pojo, treeModel.getTreePath().getParentIfAny()));
    }

    public int childCountOf(_TreeNodeMemento treeModel) {
        if (treeModel == null) {
            return 0;
        }
        Object pojoNode = this.demementify(treeModel);
        if (pojoNode == null) {
            return 0;
        }
        return this.wrappedTreeAdapter().childCountOf(pojoNode);
    }

    public Stream<_TreeNodeMemento> childrenOf(_TreeNodeMemento treeModel) {
        if (treeModel == null) {
            return Stream.empty();
        }
        Object pojoNode = this.demementify(treeModel);
        if (pojoNode == null) {
            return Stream.empty();
        }
        return this.wrappedTreeAdapter().childrenOf(pojoNode).map(this.newPojoToTreeModelMapper(treeModel));
    }

    _TreeNodeMemento mementify(@NonNull Object pojo, @NonNull TreePath treePath) {
        if (pojo == null) {
            throw new NullPointerException("pojo is marked non-null but is null");
        }
        if (treePath == null) {
            throw new NullPointerException("treePath is marked non-null but is null");
        }
        return new _TreeNodeMemento(treePath, (Bookmark)ManagedObject.adaptSingular((SpecificationLoader)this.getSpecificationLoader(), (Object)pojo).getBookmark().orElseThrow());
    }

    @Nullable
    private Object demementify(_TreeNodeMemento model) {
        Objects.requireNonNull(model);
        return model.getPojo();
    }

    private Function<Object, _TreeNodeMemento> newPojoToTreeModelMapper(_TreeNodeMemento parent) {
        return IndexedFunction.zeroBased((indexWithinSiblings, pojo) -> this.mementify(pojo, parent.getTreePath().append(indexWithinSiblings)));
    }

    private TreeAdapter wrappedTreeAdapter() {
        if (this.wrappedTreeAdapter != null) {
            return this.wrappedTreeAdapter;
        }
        try {
            this.wrappedTreeAdapter = (TreeAdapter)this.getFactoryService().getOrCreate(this.treeAdapterClass);
            return this.wrappedTreeAdapter;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to instantiate tree adapter", e);
        }
    }
}

