/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.pages.value;

import org.apache.causeway.applib.services.publishing.spi.PageRenderSubscriber;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.ValueModel;
import org.apache.causeway.viewer.wicket.model.util.PageParameterUtils;
import org.apache.causeway.viewer.wicket.ui.pages.PageAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.model.IModel;

@AuthorizeInstantiation(value={"org.apache.causeway.security.AUTHORIZED_USER_ROLE"})
public class ValuePage
extends PageAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_ACTION_NAME = "actionName";
    private final ValueModel valueModel;

    public ValuePage(ValueModel valueModel) {
        this(valueModel, ValuePage.actionNameFrom(valueModel));
    }

    private ValuePage(ValueModel valueModel, String actionName) {
        super(PageParameterUtils.newPageParameters(), actionName, UiComponentType.VALUE);
        this.valueModel = valueModel;
        Wkt.labelAdd(this.themeDiv, ID_ACTION_NAME, actionName);
        this.addChildComponents(this.themeDiv, (IModel<?>)valueModel);
        this.addBookmarkedPages(this.themeDiv);
    }

    private static String actionNameFrom(ValueModel valueModel) {
        ActionModel actionModel = valueModel.getActionModelHint();
        if (actionModel != null) {
            return actionModel.getFriendlyName();
        }
        return "Results";
    }

    @Override
    public void onRendered(Can<PageRenderSubscriber> enabledObjectRenderSubscribers) {
        ManagedObjects.asSpecified((ManagedObject)((ManagedObject)this.valueModel.getObject())).ifPresent(managedObject -> {
            Object nullableValuePojo = managedObject.getPojo();
            enabledObjectRenderSubscribers.forEach(objectRenderSubscriber -> objectRenderSubscriber.onRenderedValue(nullableValuePojo));
        });
    }
}

