/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.actionmenu.serviceactions;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.causeway.applib.fa.FontAwesomeLayers;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.commons.applib.services.menu.MenuVisitor;
import org.apache.causeway.viewer.commons.applib.services.menu.model.MenuAction;
import org.apache.causeway.viewer.commons.applib.services.menu.model.MenuDropdown;
import org.apache.causeway.viewer.commons.applib.services.menu.model.NavbarSection;
import org.apache.causeway.viewer.wicket.model.links.LinkAndLabel;
import org.apache.causeway.viewer.wicket.ui.components.actionmenu.entityactions.LinkAndLabelFactory;
import org.apache.causeway.viewer.wicket.ui.components.actionmenu.serviceactions.CssMenuItem;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktDecorators;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public final class ServiceActionUtil {
    static void addLeafItem(MetaModelContext commonContext, CssMenuItem menuItem, ListItem<CssMenuItem> listItem, MarkupContainer parent) {
        LinkAndLabel actionUiModel = menuItem.getLinkAndLabel();
        AjaxLink menuItemActionLink = actionUiModel.getUiComponent();
        Label menuItemLabel = Wkt.labelAdd((MarkupContainer)menuItemActionLink, "menuLinkLabel", menuItem.getName());
        WktDecorators.getActionLink().decorateMenuItem((Component)listItem, actionUiModel, commonContext.getTranslationService());
        Optional faLayers = actionUiModel.lookupFontAwesomeLayers(true);
        WktDecorators.getIcon().decorate((Component)menuItemLabel, (Optional<FontAwesomeLayers>)faLayers);
        WktDecorators.getMissingIcon().decorate((Component)menuItemActionLink, (Optional<FontAwesomeLayers>)faLayers);
        Fragment leafItem = new Fragment("content", "leafItem", parent);
        leafItem.add(new Component[]{menuItemActionLink});
        listItem.add(new Component[]{leafItem});
    }

    static void addFolderItem(MetaModelContext commonContext, CssMenuItem subMenuItem, ListItem<CssMenuItem> listItem, MarkupContainer parent) {
        Wkt.cssAppend(listItem, "dropdown-submenu");
        Fragment folderItem = new Fragment("content", "folderItem", parent);
        listItem.add(new Component[]{folderItem});
        Wkt.labelAdd((MarkupContainer)folderItem, "folderName", (IModel<String>)(IModel & Serializable)() -> subMenuItem.getLinkAndLabel().getFriendlyName());
        Can<CssMenuItem> menuItems = subMenuItem.getSubMenuItems();
        Wkt.listViewAdd((MarkupContainer)folderItem, "subMenuItems", menuItems.toList(), (SerializableConsumer & Serializable)item -> {
            CssMenuItem menuItem = (CssMenuItem)listItem.getModelObject();
            if (menuItem.hasSubMenuItems()) {
                ServiceActionUtil.addFolderItem(commonContext, menuItem, (ListItem<CssMenuItem>)item, parent);
            } else {
                ServiceActionUtil.addLeafItem(commonContext, menuItem, (ListItem<CssMenuItem>)item, parent);
            }
        });
    }

    public static void buildMenu(NavbarSection navBarSection, Consumer<CssMenuItem> onNewMenuItem) {
        navBarSection.visitMenuItems((MenuVisitor)MenuBuilderWkt.of(onNewMenuItem));
    }

    @Generated
    private ServiceActionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class MenuBuilderWkt
    implements MenuVisitor {
        private final Consumer<CssMenuItem> onNewMenuItem;
        private CssMenuItem currentTopLevelMenu = null;

        public void onTopLevel(MenuDropdown menuDto) {
            this.currentTopLevelMenu = CssMenuItem.newMenuItemWithSubmenu(menuDto.name());
            this.onNewMenuItem.accept(this.currentTopLevelMenu);
        }

        public void onSectionSpacer() {
            CssMenuItem menuSection = CssMenuItem.newSpacer();
            this.currentTopLevelMenu.addSubMenuItem(menuSection);
        }

        public void onMenuAction(MenuAction menuAction) {
            CssMenuItem menuItem = CssMenuItem.newMenuItemWithLink(menuAction.name());
            this.currentTopLevelMenu.addSubMenuItem(menuItem);
            menuItem.setLinkAndLabel(LinkAndLabelFactory.linkAndLabelForMenu(menuAction));
        }

        public void onSectionLabel(String named) {
            CssMenuItem menuSectionLabel = CssMenuItem.newSectionLabel(named);
            this.currentTopLevelMenu.addSubMenuItem(menuSectionLabel);
        }

        @Generated
        private MenuBuilderWkt(Consumer<CssMenuItem> onNewMenuItem) {
            this.onNewMenuItem = onNewMenuItem;
        }

        @Generated
        public static MenuBuilderWkt of(Consumer<CssMenuItem> onNewMenuItem) {
            return new MenuBuilderWkt(onNewMenuItem);
        }
    }
}

