/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collectioncontents.icons;

import java.util.List;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.tabular.DataRow;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.ui.components.entity.header.EntityHeaderPanel;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.markup.repeater.RepeatingView;

public class CollectionContentsAsIconsPanel
extends PanelAbstract<DataTableInteractive, EntityCollectionModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_ENTITY_INSTANCE = "entityInstance";

    public CollectionContentsAsIconsPanel(String id, EntityCollectionModel model) {
        super(id, model);
        this.buildGui();
    }

    private void buildGui() {
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        List visibleAdapters = ((Can)model.getDataTableModel().getDataRowsFilteredAndSorted().getValue()).map(DataRow::getRowElement).toList();
        RepeatingView entityInstances = new RepeatingView(ID_ENTITY_INSTANCE);
        this.add(new Component[]{entityInstances});
        for (ManagedObject adapter : visibleAdapters) {
            String childId = entityInstances.newChildId();
            UiObjectWkt entityModel = UiObjectWkt.ofAdapter((ManagedObject)adapter);
            EntityHeaderPanel entitySummaryPanel = new EntityHeaderPanel(childId, entityModel);
            entityInstances.add(new Component[]{entitySummaryPanel});
        }
    }
}

