/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.tree;

import java.io.Serializable;
import java.util.Optional;
import org.apache.causeway.applib.graph.tree.TreeNode;
import org.apache.causeway.applib.graph.tree.TreeState;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.causeway.viewer.wicket.model.models.ValueModel;
import org.apache.causeway.viewer.wicket.ui.components.entity.icontitle.EntityIconAndTitlePanel;
import org.apache.causeway.viewer.wicket.ui.components.tree._TreeExpansionModel;
import org.apache.causeway.viewer.wicket.ui.components.tree._TreeModelTreeAdapter;
import org.apache.causeway.viewer.wicket.ui.components.tree._TreeModelTreeProvider;
import org.apache.causeway.viewer.wicket.ui.components.tree._TreeNodeMemento;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.extensions.markup.html.repeater.tree.AbstractTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.ITreeProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.NestedTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.Node;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

class CausewayToWicketTreeAdapter {
    CausewayToWicketTreeAdapter() {
    }

    public static MarkupContainer adapt(String id, ValueModel valueModel) {
        return valueModel == null || ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)((ManagedObject)valueModel.getObject())) ? CausewayToWicketTreeAdapter.emptyTreeComponent(id) : DomainObjectTree.of(id, (ManagedObject)valueModel.getObject());
    }

    public static MarkupContainer adapt(String id, ScalarModel scalarModel) {
        return scalarModel == null || ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)scalarModel.getObject()) ? CausewayToWicketTreeAdapter.emptyTreeComponent(id) : DomainObjectTree.of(id, scalarModel.getObject());
    }

    private static MarkupContainer emptyTreeComponent(String id) {
        return new WebMarkupContainer(id);
    }

    private static class DomainObjectTree
    extends NestedTree<_TreeNodeMemento>
    implements HasMetaModelContext {
        private static final long serialVersionUID = 1L;

        public static DomainObjectTree of(String id, ManagedObject treeNodeObject) {
            TreeNode treeNode = (TreeNode)treeNodeObject.getPojo();
            _TreeModelTreeAdapter wrappingTreeAdapter = new _TreeModelTreeAdapter(treeNode.getTreeAdapter());
            _TreeModelTreeProvider treeModelTreeProvider = new _TreeModelTreeProvider(wrappingTreeAdapter.mementify(treeNode.getValue(), treeNode.getPositionAsPath()), wrappingTreeAdapter);
            TreeState treeState = treeNode.getTreeState();
            _TreeExpansionModel treeExpansionModel = _TreeExpansionModel.of(treeState);
            return new DomainObjectTree(id, treeModelTreeProvider, treeExpansionModel);
        }

        private DomainObjectTree(String id, ITreeProvider<_TreeNodeMemento> provider, _TreeExpansionModel collapseExpandState) {
            super(id, provider, (IModel)collapseExpandState);
        }

        protected Component newContentComponent(String id, IModel<_TreeNodeMemento> node) {
            _TreeNodeMemento treeModel = (_TreeNodeMemento)node.getObject();
            EntityIconAndTitlePanel entityIconAndTitle = new EntityIconAndTitlePanel(id, treeModel.asObjectAdapterModel());
            if (this.treeExpansionModel().isSelected(treeModel.getTreePath())) {
                Wkt.cssAppend(entityIconAndTitle, "tree-node-selected");
            }
            return entityIconAndTitle;
        }

        public Component newNodeComponent(String id, IModel<_TreeNodeMemento> model) {
            Node<_TreeNodeMemento> node = new Node<_TreeNodeMemento>(id, (AbstractTree)this, model){
                private static final long serialVersionUID = 1L;

                protected Component createContent(String id, IModel<_TreeNodeMemento> model) {
                    return this.newContentComponent(id, model);
                }

                protected MarkupContainer createJunctionComponent(String id) {
                    final 1 node = this;
                    final Runnable toggleExpandCollapse = (Runnable & Serializable)() -> this.toggle();
                    return new AjaxFallbackLink<Void>(id){
                        private static final long serialVersionUID = 1L;

                        public void onClick(Optional<AjaxRequestTarget> target) {
                            toggleExpandCollapse.run();
                        }

                        public boolean isEnabled() {
                            return this.getProvider().hasChildren((Object)((_TreeNodeMemento)node.getModelObject()));
                        }

                        public boolean isEnabledInHierarchy() {
                            return true;
                        }
                    };
                }
            };
            node.setOutputMarkupId(true);
            return node;
        }

        public AbstractTree.State getState(_TreeNodeMemento t) {
            return this.treeExpansionModel().contains(t.getTreePath()) ? AbstractTree.State.EXPANDED : AbstractTree.State.COLLAPSED;
        }

        public void expand(_TreeNodeMemento t) {
            this.treeExpansionModel().onExpand(t);
            super.expand((Object)t);
        }

        public void collapse(_TreeNodeMemento t) {
            this.treeExpansionModel().onCollapse(t);
            super.collapse((Object)t);
        }

        private _TreeExpansionModel treeExpansionModel() {
            return (_TreeExpansionModel)this.getModel();
        }
    }
}

