/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.widgets.breadcrumbs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.viewer.wicket.model.mementos.PageParameterNames;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class BreadcrumbModel
implements HasMetaModelContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_SIZE = 5;
    private final Map<String, Bookmark> bookmarkByOidStr = _Maps.newHashMap();
    private final Map<Bookmark, String> oidStrByBookmark = _Maps.newHashMap();
    private final List<Bookmark> list = _Lists.newArrayList();
    private String mostRecentlyVisitedOidStr;

    public List<UiObjectWkt> getList() {
        ArrayList entityModels = _Lists.newArrayList();
        for (Bookmark bookmark : this.list) {
            UiObjectWkt entityModel = this.toEntityModel(bookmark);
            entityModels.add(entityModel);
        }
        return Collections.unmodifiableList(entityModels);
    }

    public void visitedHomePage() {
        this.mostRecentlyVisitedOidStr = null;
    }

    public UiObjectWkt getMostRecentlyVisited() {
        return this.mostRecentlyVisitedOidStr != null ? this.lookup(this.mostRecentlyVisitedOidStr) : null;
    }

    public void visited(UiObjectWkt entityModel) {
        String oidStr;
        if (entityModel.getTypeOfSpecification().isViewModel()) {
            this.mostRecentlyVisitedOidStr = null;
            return;
        }
        this.mostRecentlyVisitedOidStr = oidStr = this.oidStrFrom(entityModel);
        this.remove(oidStr);
        this.addToStart(oidStr, entityModel);
        this.trimTo(5);
    }

    private String oidStrFrom(UiObjectWkt entityModel) {
        PageParameters pageParameters = entityModel.getPageParametersWithoutUiHints();
        return this.oidStrFrom(pageParameters);
    }

    private String oidStrFrom(PageParameters pageParameters) {
        String oidStr = PageParameterNames.OBJECT_OID.getStringFrom(pageParameters);
        if (oidStr == null) {
            return null;
        }
        try {
            return Bookmark.parse((String)oidStr).map(Bookmark::stringify).orElse(null);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void addToStart(String oidStr, UiObjectWkt entityModel) {
        Bookmark bookmark = entityModel.getOwnerBookmark();
        this.bookmarkByOidStr.put(oidStr, bookmark);
        this.oidStrByBookmark.put(bookmark, oidStr);
        this.list.add(0, bookmark);
    }

    private void trimTo(int size) {
        if (this.list.size() <= size) {
            return;
        }
        List<Bookmark> bookmarksToRemove = this.list.subList(size, this.list.size());
        for (Bookmark bookmark : bookmarksToRemove) {
            String oidStr = this.oidStrByBookmark.get(bookmark);
            this.remove(oidStr, bookmark);
        }
    }

    public UiObjectWkt lookup(String oidStr) {
        if (oidStr == null) {
            return null;
        }
        Bookmark bookmark = this.bookmarkByOidStr.get(oidStr);
        if (bookmark == null) {
            return null;
        }
        return this.toEntityModel(bookmark);
    }

    public void detach() {
    }

    void remove(String oid) {
        Bookmark existingBookmark = this.bookmarkByOidStr.get(oid);
        if (existingBookmark != null) {
            this.remove(oid, existingBookmark);
        }
    }

    public void remove(UiObjectWkt entityModel) {
        Bookmark bookmark = entityModel.getOwnerBookmark();
        String oidStr = this.oidStrByBookmark.get(bookmark);
        if (oidStr != null) {
            this.remove(oidStr, bookmark);
        }
    }

    protected UiObjectWkt toEntityModel(Bookmark bookmark) {
        return UiObjectWkt.ofBookmark((Bookmark)bookmark);
    }

    private void remove(String oid, Bookmark bookmark) {
        this.bookmarkByOidStr.remove(oid);
        this.oidStrByBookmark.remove(bookmark);
        this.list.remove(bookmark);
    }

    public synchronized void clear() {
        this.bookmarkByOidStr.clear();
        this.oidStrByBookmark.clear();
        this.list.clear();
        this.mostRecentlyVisitedOidStr = null;
    }
}

