/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui;

import lombok.Generated;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.panels.PanelUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.CssResourceReference;

public abstract class ComponentFactoryAbstract
implements ComponentFactory {
    @Generated
    private static final Logger log = LogManager.getLogger(ComponentFactoryAbstract.class);
    private transient MetaModelContext metaModelContext;
    private final UiComponentType componentType;
    private final String name;
    private final Class<?> componentTypeClass;

    protected ComponentFactoryAbstract(UiComponentType componentType) {
        this(componentType, null, null);
    }

    protected ComponentFactoryAbstract(UiComponentType componentType, String name) {
        this(componentType, name, null);
    }

    protected ComponentFactoryAbstract(UiComponentType componentType, Class<?> componentClass) {
        this(componentType, null, componentClass);
    }

    protected ComponentFactoryAbstract(UiComponentType componentType, String name, Class<?> componentTypeClass) {
        this.componentType = componentType;
        String string = this.name = name != null ? name : this.getClass().getSimpleName();
        if (componentTypeClass != null && ComponentFactory.class.isAssignableFrom(componentTypeClass)) {
            throw new IllegalArgumentException("specified a ComponentFactory as a componentTypeClass... you probably meant the component instead? componentClass = " + componentTypeClass.getName());
        }
        this.componentTypeClass = componentTypeClass;
        log.debug("new factory {}", new Supplier[]{this::toString});
    }

    @Override
    public final ComponentFactory.ApplicationAdvice appliesTo(UiComponentType componentType, IModel<?> model) {
        if (componentType != this.getComponentType()) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        return this.appliesTo(model);
    }

    protected abstract ComponentFactory.ApplicationAdvice appliesTo(IModel<?> var1);

    protected final ComponentFactory.ApplicationAdvice appliesIf(boolean b) {
        return ComponentFactory.ApplicationAdvice.appliesIf(b);
    }

    protected final ComponentFactory.ApplicationAdvice appliesExclusivelyIf(boolean b) {
        return ComponentFactory.ApplicationAdvice.appliesExclusivelyIf(b);
    }

    @Override
    public final Component createComponent(IModel<?> model) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((UiComponentType)this.getComponentType()).toString();
        log.debug("creating component {}", supplierArray);
        return this.createComponent(this.getComponentType().getId(), model);
    }

    @Override
    public abstract Component createComponent(String var1, IModel<?> var2);

    @Override
    public CssResourceReference getCssResourceReference() {
        return PanelUtil.cssResourceReferenceFor(this.componentTypeClass);
    }

    @Generated
    public String toString() {
        return "ComponentFactoryAbstract(componentType=" + String.valueOf(this.getComponentType()) + ", name=" + this.getName() + ", componentTypeClass=" + String.valueOf(this.getComponentTypeClass()) + ")";
    }

    @Generated
    public MetaModelContext getMetaModelContext() {
        return this.metaModelContext;
    }

    @Generated
    public void setMetaModelContext(MetaModelContext metaModelContext) {
        this.metaModelContext = metaModelContext;
    }

    @Override
    @Generated
    public UiComponentType getComponentType() {
        return this.componentType;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public Class<?> getComponentTypeClass() {
        return this.componentTypeClass;
    }
}

