/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.blobclob;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.causeway.applib.services.placeholder.PlaceholderRenderService;
import org.apache.causeway.applib.value.NamedWithMimeType;
import org.apache.causeway.viewer.commons.model.components.UiString;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanelWithFormField;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.IResource;

abstract class BlobOrClobAttributePanel<T extends NamedWithMimeType>
extends AttributePanelWithFormField<T> {
    private static final long serialVersionUID = 1L;

    protected BlobOrClobAttributePanel(String id, UiAttributeWkt attributeModel, Class<T> type) {
        super(id, attributeModel, type);
    }

    protected abstract IModel<List<FileUpload>> fileUploadModel();

    protected abstract IResource newResource(T var1);

    @Override
    protected Optional<AttributeFragmentFactory.InputFragment> getInputFragmentType() {
        return Optional.of(AttributeFragmentFactory.InputFragment.FILE);
    }

    @Override
    protected FormComponent createFormComponent(String id, UiAttributeWkt attributeModel) {
        String initialCaption = this.outputFormatAsString();
        FileUploadField fileUploadField = Wkt.fileUploadField(id, initialCaption, this.fileUploadModel());
        this.addAcceptFilterTo((Component)fileUploadField);
        return fileUploadField;
    }

    @Override
    protected UiString obtainOutputFormat() {
        String caption = this.getBlobOrClobFromModel().map(NamedWithMimeType::name).orElseGet(() -> this.getPlaceholderRenderService().asText(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION));
        return UiString.text((String)caption);
    }

    @Override
    protected Component createComponentForOutput(String id) {
        Fragment link = AttributeFragmentFactory.CompactFragment.LINK.createFragment(id, (MarkupContainer)this, scalarValueId -> this.createDownloadLink((String)scalarValueId, (IModel<String>)(IModel & Serializable)() -> this.outputFormatAsString()));
        return link;
    }

    private void addAcceptFilterTo(Component component) {
        Wkt.attributeReplace(component, "accept", this.attributeModel().getFileAccept());
    }

    private Optional<T> getBlobOrClobFromModel() {
        return Optional.ofNullable((NamedWithMimeType)this.attributeModel().unwrapAs(this.type));
    }

    private Component createDownloadLink(String id, IModel<String> labelModel) {
        return this.getBlobOrClobFromModel().map(this::newResource).map(resource -> Wkt.downloadLinkNoCache(id, resource)).map(linkContainer -> {
            WktTooltips.addTooltip(linkContainer, this.translate("Download file"));
            Wkt.labelAdd(linkContainer, AttributeFragmentFactory.CompactFragment.ID_LINK_LABEL, labelModel);
            return linkContainer;
        }).orElseGet(() -> {
            WebMarkupContainer linkContainer = Wkt.container(id);
            Wkt.markupAdd((MarkupContainer)linkContainer, AttributeFragmentFactory.CompactFragment.ID_LINK_LABEL, this.getPlaceholderRenderService().asHtml(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION));
            return linkContainer;
        });
    }
}

