/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.markup;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.causeway.applib.value.semantics.Renderer;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.viewer.commons.prism.PrismHighlighter;
import org.apache.causeway.viewer.commons.prism.PrismTheme;
import org.apache.causeway.viewer.wicket.ui.util.PrismResourcesWkt;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.jspecify.annotations.Nullable;

record HighlightBehavior(PrismTheme theme, List<CssResourceReference> cssResourceReferences) {
    private static final Map<Renderer.SyntaxHighlighter, HighlightBehavior> cache = new ConcurrentHashMap<Renderer.SyntaxHighlighter, HighlightBehavior>();

    private HighlightBehavior(PrismTheme theme) {
        this(theme, PrismResourcesWkt.cssResources(theme));
    }

    public static Optional<HighlightBehavior> lookup(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Renderer.SyntaxHighlighter syntaxHighlighter) {
        if (syntaxHighlighter == null || syntaxHighlighter == Renderer.SyntaxHighlighter.NONE) {
            return Optional.empty();
        }
        return Optional.of(cache.computeIfAbsent(syntaxHighlighter, key -> switch (syntaxHighlighter) {
            case Renderer.SyntaxHighlighter.PRISM_DEFAULT -> new HighlightBehavior(PrismTheme.DEFAULT);
            case Renderer.SyntaxHighlighter.PRISM_COY -> new HighlightBehavior(PrismTheme.COY);
            default -> throw _Exceptions.unmatchedCase((Object)syntaxHighlighter);
        }));
    }

    void renderHead(IHeaderResponse response) {
        for (CssResourceReference cssRef : this.cssResourceReferences()) {
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)cssRef));
        }
    }

    String htmlContentPostProcess(String htmlContent) {
        String highlighted = new PrismHighlighter().apply(htmlContent);
        return highlighted;
    }
}

