/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.layout.bs.tabs;

import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.AjaxBootstrapTabbedPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.causeway.applib.layout.grid.bootstrap.BSTab;
import org.apache.causeway.applib.layout.grid.bootstrap.BSTabGroup;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.model.util.ComponentHintKey;
import org.apache.causeway.viewer.wicket.ui.components.layout.bs.col.RepeatingViewWithDynamicallyVisibleContent;
import org.apache.causeway.viewer.wicket.ui.components.layout.bs.tabs.TabPanel;
import org.apache.causeway.viewer.wicket.ui.panels.HasDynamicallyVisibleContent;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TabGroupPanel
extends AjaxBootstrapTabbedPanel<ITab>
implements HasDynamicallyVisibleContent {
    private static final long serialVersionUID = 1L;
    public static final String SESSION_ATTR_SELECTED_TAB = "selectedTab";
    private final ComponentHintKey selectedTabHintKey;
    private final UiObjectWkt objectModel;

    private static List<ITab> tabsFor(final UiObjectWkt objectModel, BSTabGroup bsTabGroup) {
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        List tablist = _NullSafe.stream((Collection)bsTabGroup.getTabs()).filter(BSTab.Predicates.notEmpty()).collect(Collectors.toList());
        for (final BSTab bsTab : tablist) {
            final RepeatingViewWithDynamicallyVisibleContent repeatingViewWithDynamicallyVisibleContent = TabPanel.newRows(objectModel, bsTab);
            String tabName = bsTab.getName();
            tabs.add((ITab)new AbstractTab((IModel)Model.of((Serializable)((Object)tabName))){
                private static final long serialVersionUID = 1L;

                public Panel getPanel(String panelId) {
                    return new TabPanel(panelId, objectModel, bsTab, repeatingViewWithDynamicallyVisibleContent);
                }

                public boolean isVisible() {
                    return repeatingViewWithDynamicallyVisibleContent.isVisible();
                }
            });
        }
        return tabs;
    }

    public TabGroupPanel(String id, UiObjectWkt objectModel, BSTabGroup bsTabGroup) {
        super(id, TabGroupPanel.tabsFor(objectModel, bsTabGroup));
        this.objectModel = objectModel;
        this.selectedTabHintKey = ComponentHintKey.create((MetaModelContext)objectModel.getMetaModelContext(), (Component)this, (String)SESSION_ATTR_SELECTED_TAB);
    }

    protected void onInitialize() {
        this.setSelectedTabFromSessionIfAny(this);
        super.onInitialize();
    }

    public TabbedPanel<ITab> setSelectedTab(int index) {
        this.selectedTabHintKey.set(this.objectModel.getOwnerBookmark(), "" + index);
        return super.setSelectedTab(index);
    }

    private void setSelectedTabFromSessionIfAny(AjaxBootstrapTabbedPanel<ITab> ajaxBootstrapTabbedPanel) {
        String selectedTabStr = this.selectedTabHintKey.get(this.objectModel.getOwnerBookmark());
        Integer tabIndex = this.parse(selectedTabStr);
        if (tabIndex != null) {
            int numTabs = ajaxBootstrapTabbedPanel.getTabs().size();
            if (tabIndex < numTabs) {
                ajaxBootstrapTabbedPanel.setSelectedTab(tabIndex.intValue());
            }
        }
    }

    private Integer parse(String selectedTabStr) {
        try {
            return Integer.parseInt(selectedTabStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public boolean isVisible() {
        return _NullSafe.stream((Collection)this.getTabs()).anyMatch(ITab::isVisible);
    }
}

