/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.table.head;

import de.agilecoders.wicket.core.util.Attributes;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.ActionColumn;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.TitleColumn;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.ToggleboxColumn;
import org.apache.causeway.viewer.wicket.ui.components.table.CausewayAjaxDataTable;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.OrderByBorder;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IStyledColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

abstract class HeadersToolbarAbstract<S>
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_SORT_NONE = "fa fa-sort";
    private static final String CLASS_SORT_UP = "fa fa-sort-up";
    private static final String CLASS_SORT_DOWN = "fa fa-sort-down";
    private final boolean useIndicatorForSortableColumn;

    public <T> HeadersToolbarAbstract(final DataTable<T, S> table, final ISortStateLocator<S> stateLocator, CausewayConfiguration.Viewer.Wicket wicketConfig) {
        super(table);
        this.useIndicatorForSortableColumn = wicketConfig.isUseIndicatorForSortableColumn();
        RefreshingView headers = new RefreshingView<IColumn<T, S>>("headers"){
            private static final long serialVersionUID = 1L;

            protected Iterator<IModel<IColumn<T, S>>> getItemModels() {
                LinkedList<Model> columnsModels = new LinkedList<Model>();
                for (IColumn column : table.getColumns()) {
                    columnsModels.add(Model.of((Serializable)column));
                }
                return columnsModels.iterator();
            }

            protected void populateItem(Item<IColumn<T, S>> item) {
                WebMarkupContainer header;
                final IColumn column = (IColumn)item.getModelObject();
                if (!HeadersToolbarAbstract.this.isDecoratedWithDataTablesNet() && column.isSortable()) {
                    header = HeadersToolbarAbstract.this.newSortableHeader("header", column.getSortProperty(), stateLocator);
                    if (column instanceof IStyledColumn) {
                        header.add(new Behavior[]{new CssAttributeBehavior(){
                            private static final long serialVersionUID = 1L;

                            @Override
                            protected String getCssClass() {
                                return ((IStyledColumn)column).getCssClass();
                            }
                        }});
                    }
                } else {
                    header = new WebMarkupContainer("header");
                }
                item.add(new Component[]{header});
                item.setRenderBodyOnly(true);
                Component label = column.getHeader("label");
                Component sortIcon = HeadersToolbarAbstract.this.newSortIcon("sortIcon", column, stateLocator);
                header.add(new Component[]{label, sortIcon});
                if (column instanceof TitleColumn) {
                    Wkt.cssAppend(header, "title-column");
                } else if (column instanceof ActionColumn) {
                    Wkt.cssAppend(header, "action-column");
                }
                if (!(column instanceof ToggleboxColumn)) {
                    Wkt.cssAppend(label, "column-header-label");
                }
                Wkt.cssAppend(header, column.isSortable() ? "column-sortable" : "column-nonsortable");
            }
        };
        this.add(new Component[]{headers});
    }

    private boolean isDecoratedWithDataTablesNet() {
        return _Casts.castTo(CausewayAjaxDataTable.class, (Object)this.getTable()).map(CausewayAjaxDataTable::isDecoratedWithDataTablesNet).orElse(false);
    }

    protected <T> Component newSortIcon(String id, final IColumn<T, S> column, final ISortStateLocator<S> stateLocator) {
        return new WebComponent(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (!HeadersToolbarAbstract.this.isDecoratedWithDataTablesNet() && column.isSortable()) {
                    SortOrder sortOrder;
                    ISortState sortState = stateLocator.getSortState();
                    Object sortProperty = column.getSortProperty();
                    SortOrder sortOrder2 = sortOrder = sortProperty == null ? SortOrder.NONE : sortState.getPropertySortOrder(sortProperty);
                    if (sortOrder == SortOrder.ASCENDING) {
                        Attributes.addClass((ComponentTag)tag, (String[])new String[]{HeadersToolbarAbstract.CLASS_SORT_UP});
                    } else if (sortOrder == SortOrder.DESCENDING) {
                        Attributes.addClass((ComponentTag)tag, (String[])new String[]{HeadersToolbarAbstract.CLASS_SORT_DOWN});
                    } else if (HeadersToolbarAbstract.this.useIndicatorForSortableColumn) {
                        Attributes.addClass((ComponentTag)tag, (String[])new String[]{HeadersToolbarAbstract.CLASS_SORT_NONE});
                    }
                }
            }
        };
    }

    protected WebMarkupContainer newSortableHeader(String headerId, S property, ISortStateLocator<S> locator) {
        return new OrderByBorder<S>(headerId, property, locator){
            private static final long serialVersionUID = 1L;

            protected void onSortChanged() {
                HeadersToolbarAbstract.this.getTable().setCurrentPage(0L);
            }
        };
    }

    static abstract class CssAttributeBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;

        CssAttributeBehavior() {
        }

        protected abstract String getCssClass();

        public void onComponentTag(Component component, ComponentTag tag) {
            Wkt.cssAppend(tag, this.getCssClass());
        }
    }
}

