/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.tree;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.causeway.applib.graph.tree.TreePath;
import org.apache.causeway.applib.graph.tree.TreeState;
import org.apache.causeway.core.metamodel.tree.TreeNodeMemento;
import org.apache.wicket.model.IModel;

record TreeExpansionModel(TreeState treeState, Set<TreeNodeMemento> expandedNodes) implements IModel<Set<TreeNodeMemento>>
{
    private TreeExpansionModel(TreeState treeState) {
        this(treeState, treeState.expandedNodePaths().stream().map(TreeNodeMemento::new).collect(Collectors.toSet()));
    }

    public static TreeExpansionModel of(TreeState treeState) {
        return new TreeExpansionModel(treeState);
    }

    public void onExpand(TreeNodeMemento t) {
        this.treeState.expandedNodePaths().add(t.treePath());
    }

    public void onCollapse(TreeNodeMemento t) {
        this.treeState.expandedNodePaths().remove(t.treePath());
    }

    public boolean contains(TreePath treePath) {
        return this.treeState.expandedNodePaths().contains(treePath);
    }

    public boolean isSelected(TreePath treePath) {
        return this.treeState.selectedNodePaths().contains(treePath);
    }

    public Set<TreeNodeMemento> getObject() {
        return this.expandedNodes;
    }

    @Override
    public String toString() {
        return this.treeState.toString();
    }
}

