/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.widgets.zclip;

import de.agilecoders.wicket.jquery.util.Strings2;
import java.io.Serializable;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.wicket.model.models.ObjectAdapterModel;
import org.apache.causeway.viewer.wicket.ui.components.widgets.zclip.SimpleClipboardModalWindow;
import org.apache.causeway.viewer.wicket.ui.components.widgets.zclip.SimpleClipboardModalWindowForm;
import org.apache.causeway.viewer.wicket.ui.components.widgets.zclip.SimpleClipboardModalWindowPanel;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class ZeroClipboardPanel
extends PanelAbstract<ManagedObject, ObjectAdapterModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_COPY_LINK = "copyLink";
    private static final String ID_SIMPLE_CLIPBOARD_MODAL_WINDOW = "simpleClipboardModalWindow";
    private AjaxLink<Void> copyLink;
    private SimpleClipboardModalWindow simpleClipboardModalWindow;

    public ZeroClipboardPanel(String id, ObjectAdapterModel objectModel) {
        super(id, objectModel);
    }

    protected void onInitialize() {
        super.onInitialize();
        if (this.copyLink == null) {
            this.copyLink = this.createLink(ID_COPY_LINK);
            this.addOrReplace(new Component[]{this.copyLink});
        }
        ObjectAdapterModel model = (ObjectAdapterModel)this.getModel();
        this.addSimpleClipboardModalWindow();
        this.setVisible(model.getRenderingHint().isNotInTable() && model.isViewingMode());
        this.setVisibilityAllowed(false);
    }

    private AjaxLink<Void> createLink(String linkId) {
        return this.newSimpleClipboardLink(linkId);
    }

    private AjaxLink<Void> newSimpleClipboardLink(String linkId) {
        return Wkt.link(linkId, (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)target -> {
            String contentId = this.simpleClipboardModalWindow.getContentId();
            SimpleClipboardModalWindowPanel panel = new SimpleClipboardModalWindowPanel(contentId);
            SimpleClipboardModalWindowForm form = new SimpleClipboardModalWindowForm("form");
            TextField textField = new TextField("textField", (IModel)new LoadableDetachableModel<String>(){
                private static final long serialVersionUID = 1L;

                protected String load() {
                    Class pageClass = ZeroClipboardPanel.this.getPage().getPageClass();
                    ObjectAdapterModel objectModel = (ObjectAdapterModel)ZeroClipboardPanel.this.getModel();
                    PageParameters pageParameters = objectModel.getPageParameters();
                    CharSequence urlFor = ZeroClipboardPanel.this.getRequestCycle().urlFor(pageClass, pageParameters);
                    return ZeroClipboardPanel.this.getRequestCycle().getUrlRenderer().renderFullUrl(Url.parse((CharSequence)urlFor));
                }
            });
            panel.add(new Component[]{form});
            form.add(new Component[]{textField});
            textField.setOutputMarkupId(true);
            CharSequence modalId = Strings2.escapeMarkupId((CharSequence)this.simpleClipboardModalWindow.getMarkupId());
            CharSequence textFieldId = Strings2.escapeMarkupId((CharSequence)textField.getMarkupId());
            target.appendJavaScript((CharSequence)String.format("$('#%s').one('shown.bs.modal', function(){Wicket.$('%s').select();});", modalId, textFieldId));
            this.simpleClipboardModalWindow.setPanel((Component)panel, (AjaxRequestTarget)target);
            this.simpleClipboardModalWindow.showPrompt((AjaxRequestTarget)target);
            target.focusComponent((Component)textField);
        });
    }

    private void addSimpleClipboardModalWindow() {
        this.simpleClipboardModalWindow = SimpleClipboardModalWindow.newModalWindow(ID_SIMPLE_CLIPBOARD_MODAL_WINDOW);
        this.addOrReplace(new Component[]{this.simpleClipboardModalWindow});
    }
}

