/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.temporal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime.DatetimePickerConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime.DatetimePickerIconConfig;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeConfig
extends AbstractConfig {
    private static final long serialVersionUID = 1L;
    private static final IKey<Boolean> Readonly = DateTimeConfig.newKey((String)"readonly", (Object)false);
    private static final IKey<Boolean> IgnoreReadonly = DateTimeConfig.newKey((String)"ignoreReadonly", (Object)false);
    private static final IKey<Boolean> AllowInputToggle = DateTimeConfig.newKey((String)"allowInputToggle", (Object)false);
    private static final IKey<Boolean> KeepOpen = DateTimeConfig.newKey((String)"keepOpen", (Object)false);
    private static final IKey<String> StartDate = DateTimeConfig.newKey((String)"startDate", null);
    private static final IKey<String> EndDate = DateTimeConfig.newKey((String)"endDate", null);
    private static final IKey<String> _ViewMode = DateTimeConfig.newKey((String)"viewMode", (Object)ViewMode.days.name());
    private static final IKey<TodayButton> ShowTodayButton = DateTimeConfig.newKey((String)"todayBtn", (Object)((Object)TodayButton.FALSE));
    private static final IKey<Boolean> KeyboardNavigation = DateTimeConfig.newKey((String)"keyboardNavigation", (Object)true);
    private static final IKey<Boolean> SideBySide = DateTimeConfig.newKey((String)"sideBySide", (Object)false);
    private static final IKey<Boolean> UseCurrent = DateTimeConfig.newKey((String)"useCurrent", (Object)true);
    private static final IKey<String> MinDate = DateTimeConfig.newKey((String)"minDate", null);
    private static final IKey<String> MaxDate = DateTimeConfig.newKey((String)"maxDate", null);
    private static final IKey<String> Locale = DateTimeConfig.newKey((String)"locale", null);
    private static final IKey<String> Format = DateTimeConfig.newKey((String)"format", null);
    private static final IKey<Integer> WeekStart = DateTimeConfig.newKey((String)"weekStart", (Object)0);
    private static final IKey<Boolean> HighlightToday = DateTimeConfig.newKey((String)"todayHighlight", (Object)false);
    private static final IKey<Boolean> AutoClose = DateTimeConfig.newKey((String)"autoclose", (Object)false);
    private static final IKey<Boolean> ForceParse = DateTimeConfig.newKey((String)"forceParse", (Object)true);
    private static final IKey<Boolean> CalendarWeeks = DateTimeConfig.newKey((String)"calendarWeeks", (Object)false);
    private static final IKey<DatetimePickerIconConfig> Icons = DateTimeConfig.newKey((String)"icons", null);

    public DateTimeConfig useLocale(Locale locale) {
        this.put(Locale, locale.getLanguage());
        return this;
    }

    public String getFormat() {
        return this.getString(Format);
    }

    public DateTimeConfig keepOpen(boolean keepOpen) {
        this.put(KeepOpen, keepOpen);
        return this;
    }

    public DateTimeConfig allowInputToggle(boolean allowInputToggle) {
        this.put(AllowInputToggle, allowInputToggle);
        return this;
    }

    public DateTimeConfig ignoreReadonly(boolean ignoreReadonly) {
        this.put(IgnoreReadonly, ignoreReadonly);
        return this;
    }

    public DateTimeConfig readonly(boolean readonly) {
        this.put(Readonly, readonly);
        return this;
    }

    public DateTimeConfig withStartDate(DateTime value) {
        String startDate;
        String format = this.getFormat();
        if (Strings.isEmpty((String)format)) {
            startDate = value.toString();
        } else {
            DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)format);
            startDate = dateTimeFormatter.print((ReadableInstant)value);
        }
        this.put(StartDate, startDate);
        return this;
    }

    public DateTimeConfig withEndDate(DateTime value) {
        String endDate;
        Args.notNull((Object)value, (String)"value");
        String format = this.getFormat();
        if (Strings.isEmpty((String)format)) {
            endDate = value.toString();
        } else {
            DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)format);
            endDate = dateTimeFormatter.print((ReadableInstant)value);
        }
        this.put(EndDate, endDate);
        return this;
    }

    public DateTimeConfig withView(ViewMode value) {
        this.put(_ViewMode, value.name());
        return this;
    }

    public DateTimeConfig withFormat(String value) {
        this.put(Format, value);
        return this;
    }

    public DateTimeConfig withWeekStart(Day value) {
        this.put(WeekStart, value.ordinal());
        return this;
    }

    public DateTimeConfig allowKeyboardNavigation(boolean value) {
        this.put(KeyboardNavigation, value);
        return this;
    }

    public DateTimeConfig sideBySide(boolean value) {
        this.put(SideBySide, value);
        return this;
    }

    public DateTimeConfig highlightToday(boolean value) {
        this.put(HighlightToday, value);
        return this;
    }

    public DateTimeConfig showTodayButton(TodayButton value) {
        this.put(ShowTodayButton, (Object)value);
        return this;
    }

    public DateTimeConfig forceParse(boolean value) {
        this.put(ForceParse, value);
        return this;
    }

    public DateTimeConfig useCalendarWeeks(boolean value) {
        this.put(CalendarWeeks, value);
        return this;
    }

    public DateTimeConfig useCurrent(boolean value) {
        this.put(UseCurrent, value);
        return this;
    }

    public DateTimeConfig minDate(String value) {
        this.put(MinDate, value);
        return this;
    }

    public DateTimeConfig maxDate(String value) {
        this.put(MaxDate, value);
        return this;
    }

    public DateTimeConfig autoClose(boolean value) {
        this.put(AutoClose, value);
        return this;
    }

    public DateTimeConfig withButtons(Map<String, Boolean> buttons) {
        this.put(DatetimePickerConfig.newKey((String)"buttons", null), Map.of("showToday", Boolean.TRUE.equals(buttons.get("showToday")), "showClear", Boolean.TRUE.equals(buttons.get("showClear")), "showClose", Boolean.TRUE.equals(buttons.get("showClose"))));
        return this;
    }

    public DateTimeConfig withIcons(DatetimePickerIconConfig iconConfig) {
        this.put(Icons, iconConfig);
        return this;
    }

    public static enum ViewMode {
        months,
        years,
        days;

    }

    public static enum Day {
        Sunday,
        Monday,
        Tuesday,
        Wednesday,
        Thursday,
        Friday,
        Saturday;

    }

    @JsonSerialize(using=TodayButtonSerializer.class)
    public static enum TodayButton {
        TRUE,
        FALSE,
        LINKED;

    }

    private static class TodayButtonSerializer
    extends JsonSerializer<TodayButton> {
        private TodayButtonSerializer() {
        }

        public void serialize(TodayButton value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            switch (value.ordinal()) {
                case 0: {
                    jgen.writeBoolean(true);
                    break;
                }
                case 1: {
                    jgen.writeBoolean(false);
                    break;
                }
                case 2: {
                    jgen.writeString("linked");
                }
            }
        }
    }
}

