/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.temporal;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Locale;
import lombok.Generated;
import org.apache.causeway.applib.services.iactnlayer.InteractionContext;
import org.apache.causeway.applib.value.semantics.TemporalCharacteristicsProvider;
import org.apache.causeway.applib.value.semantics.TemporalSupport;
import org.apache.causeway.commons.functional.Either;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.base._Temporals;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.metamodel.commons.ViewOrEditMode;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedValue;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.MmValueUtils;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.model.value.ConverterBasedOnValueSemantics;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.jspecify.annotations.NonNull;

public class TemporalDecompositionModel<T>
implements IConverter<T> {
    private static final long serialVersionUID = 1L;
    private final @NonNull Class<T> type;
    private final TemporalCharacteristicsProvider.OffsetCharacteristic offsetCharacteristic;
    private final @NonNull ZoneId userZoneId;
    private final @NonNull ConverterBasedOnValueSemantics<T> fullConverter;
    private final @NonNull ViewOrEditMode viewOrEditMode;
    private final String editingPattern;
    private ZoneId zoneId;
    private ZoneOffset zoneOffset;

    public static <T extends Temporal> TemporalDecompositionModel<T> create(Class<T> type, UiAttributeWkt attributeModel, TemporalCharacteristicsProvider.OffsetCharacteristic offsetCharacteristic, ConverterBasedOnValueSemantics<T> fullConverter) {
        _Assert.assertTrue((boolean)fullConverter.canHandle(type));
        boolean needsDecomposition = !offsetCharacteristic.isLocal() && attributeModel.getViewOrEditMode().isEditing();
        String baseEditingPattern = fullConverter.getEditingPattern();
        String editingPattern = needsDecomposition ? TemporalDecompositionModel.stripZoneSuffixFrom(baseEditingPattern) : baseEditingPattern;
        ZoneOffset userZoneId = needsDecomposition ? attributeModel.getInteractionService().currentInteractionContext().map(InteractionContext::getTimeZone).orElse(ZoneOffset.UTC) : ZoneOffset.UTC;
        TemporalDecompositionModel<T> tempDecomp = new TemporalDecompositionModel<T>(type, offsetCharacteristic, userZoneId, fullConverter, attributeModel.getViewOrEditMode(), editingPattern);
        if (needsDecomposition) {
            tempDecomp.initFrom(attributeModel.getMetaModel(), attributeModel.proposedValue());
        }
        return tempDecomp;
    }

    private void initFrom(ObjectFeature objectFeature, ManagedValue proposedValue) {
        ManagedObject temporalValue = (ManagedObject)proposedValue.getValue().getValue();
        Either zoneOrOffset = MmValueUtils.temporalDecomposition((ObjectFeature)objectFeature, (ManagedObject)temporalValue).flatMap(TemporalSupport.TemporalDecomposition::zoneOrOffset).orElseGet(() -> {
            switch (this.offsetCharacteristic) {
                case ZONED: {
                    return Either.left((Object)this.userZoneId);
                }
                case OFFSET: {
                    return Either.right((Object)this.userZoneId.getRules().getOffset(Instant.now()));
                }
            }
            throw _Exceptions.unexpectedCodeReach();
        });
        zoneOrOffset.accept(this::setZoneId, this::setZoneOffset);
    }

    public T convertToObject(String noZoneValue, Locale locale) throws ConversionException {
        String fullTemporalString = noZoneValue + this.getZoneOrOffsetSuffix();
        return (T)this.fullConverter.convertToObject(fullTemporalString, locale);
    }

    public String convertToString(T value, Locale locale) {
        return this.fullConverter.convertToString(value, locale);
    }

    private String getZoneOrOffsetSuffix() {
        switch (this.offsetCharacteristic) {
            case OFFSET: {
                return " " + _Temporals.formatZoneId((ZoneId)(this.zoneOffset == null ? ZoneOffset.UTC : this.zoneOffset), (DateTimeFormatter)_Temporals.ISO_OFFSET_ONLY_FORMAT);
            }
            case ZONED: {
                return " " + _Temporals.formatZoneId((ZoneId)(this.zoneId == null ? ZoneOffset.UTC : this.zoneId));
            }
        }
        return "";
    }

    private static String stripZoneSuffixFrom(String pattern) {
        if (pattern.endsWith("XXX")) {
            return _Strings.substring((String)pattern, (int)0, (int)-3).stripTrailing();
        }
        if (pattern.endsWith("VV")) {
            return _Strings.substring((String)pattern, (int)0, (int)-2).stripTrailing();
        }
        return pattern;
    }

    @Generated
    private TemporalDecompositionModel(@NonNull Class<T> type, TemporalCharacteristicsProvider.OffsetCharacteristic offsetCharacteristic, @NonNull ZoneId userZoneId, @NonNull ConverterBasedOnValueSemantics<T> fullConverter, @NonNull ViewOrEditMode viewOrEditMode, String editingPattern) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (userZoneId == null) {
            throw new NullPointerException("userZoneId is marked non-null but is null");
        }
        if (fullConverter == null) {
            throw new NullPointerException("fullConverter is marked non-null but is null");
        }
        if (viewOrEditMode == null) {
            throw new NullPointerException("viewOrEditMode is marked non-null but is null");
        }
        this.type = type;
        this.offsetCharacteristic = offsetCharacteristic;
        this.userZoneId = userZoneId;
        this.fullConverter = fullConverter;
        this.viewOrEditMode = viewOrEditMode;
        this.editingPattern = editingPattern;
    }

    @Generated
    public String getEditingPattern() {
        return this.editingPattern;
    }

    @Generated
    public ZoneId getZoneId() {
        return this.zoneId;
    }

    @Generated
    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    @Generated
    public ZoneOffset getZoneOffset() {
        return this.zoneOffset;
    }

    @Generated
    public void setZoneOffset(ZoneOffset zoneOffset) {
        this.zoneOffset = zoneOffset;
    }
}

