/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.temporal;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime.DatetimePickerIconConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome6IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.references.DatetimePickerCssReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.references.DatetimePickerJsReference;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.causeway.applib.locale.UserLocale;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.wicket.ui.components.attributes.temporal.DateTimeConfig;
import org.apache.causeway.viewer.wicket.ui.components.attributes.temporal._TimeFormatUtil;
import org.apache.causeway.viewer.wicket.ui.components.text.TextFieldWithConverter;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.jspecify.annotations.NonNull;

public class TextFieldWithDateTimePicker<T>
extends TextFieldWithConverter<T> {
    private static final long serialVersionUID = 1L;
    private final DateTimeConfig config;

    public TextFieldWithDateTimePicker(@NonNull String id, @NonNull IModel<T> model, @NonNull Class<T> type, boolean isRequired, @NonNull IConverter<T> converter, @NonNull String editingPattern) {
        super(id, model, type, Optional.of(converter));
        this.setOutputMarkupId(true);
        this.config = this.createDatePickerConfig(editingPattern, !isRequired);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (!this.isEnabled()) {
            return;
        }
        this.checkComponentTag(tag, "input");
        Attributes.addClass((ComponentTag)tag, (String[])new String[]{"datetimepicker-input"});
        Attributes.set((ComponentTag)tag, (String)"type", (String)"text");
        Attributes.set((ComponentTag)tag, (String)"data-toggle", (String)"datetimepicker");
        Attributes.set((ComponentTag)tag, (String)"data-target", (String)this.getMarkupId());
        Attributes.set((ComponentTag)tag, (String)"autocomplete", (String)"off");
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (!this.isEnabled()) {
            return;
        }
        response.render(DatetimePickerCssReference.asHeaderItem());
        response.render(DatetimePickerJsReference.asHeaderItem());
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createScript((Config)this.config)));
    }

    private DateTimeConfig createDatePickerConfig(String temporalPattern, boolean isInputNullable) {
        DateTimeConfig config = new DateTimeConfig();
        MetaModelContext mmc = MetaModelContext.instanceElseFail();
        config.useLocale(mmc.currentUserLocale().map(UserLocale::languageLocale).orElse(Locale.US));
        config.withFormat(_TimeFormatUtil.convertToMomentJsFormat(temporalPattern));
        config.useCalendarWeeks(true);
        config.useCurrent(false);
        config.withButtons(Map.of("showToday", true, "showClear", isInputNullable, "showClose", true));
        config.withIcons(new DatetimePickerIconConfig().useTimeIcon((IconType)FontAwesome6IconType.clock_r).useDateIcon((IconType)FontAwesome6IconType.calendar_r).useUpIcon((IconType)FontAwesome6IconType.arrow_up_s).useDownIcon((IconType)FontAwesome6IconType.arrow_down_s).usePreviousIcon((IconType)FontAwesome6IconType.chevron_left_s).useNextIcon((IconType)FontAwesome6IconType.chevron_right_s).useTodayIcon((IconType)FontAwesome6IconType.calendar_check_r).useClearIcon((IconType)FontAwesome6IconType.trash_can_r).useCloseIcon((IconType)FontAwesome6IconType.check_s));
        CausewayConfiguration.Viewer.Wicket.DatePicker causewayDatePickerConfig = mmc.getConfiguration().getViewer().getWicket().getDatePicker();
        config.minDate(causewayDatePickerConfig.getMinDate());
        config.maxDate(causewayDatePickerConfig.getMaxDate());
        config.allowInputToggle(causewayDatePickerConfig.isPopupOnFocus());
        return config;
    }

    private CharSequence createScript(Config config) {
        String script = JQuery.$((Component)this).chain((CharSequence)"datetimepicker", config, new Config[0]).get();
        return script;
    }
}

