/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.table.nav.pagesize;

import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.applib.services.i18n.TranslationContext;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.wicket.model.tableoption.PagesizeChoice;
import org.apache.causeway.viewer.wicket.ui.components.table.DataTableWithPagesAndFilter;
import org.apache.causeway.viewer.wicket.ui.components.widgets.links.AjaxLinkNoPropagate;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktLinks;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.Model;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.jspecify.annotations.NonNull;

public class PagesizeChooser
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String ID_PAGESIZE_BUTTON = "pagesizeButton";
    private static final String ID_PAGESIZE_LABEL = "pagesizeLabel";
    private static final String ID_PAGESIZE_CHOICE = "pagesizeChoice";
    private static final String ID_PAGESIZE_CHOICES = "pagesizeChoices";
    private static final String ID_VIEW_ITEM_TITLE = "viewItemTitle";
    private static final String ID_VIEW_ITEM_ICON = "viewItemIcon";
    private static final String ID_VIEW_ITEM_CHECKMARK = "viewItemCheckmark";
    final DataTableWithPagesAndFilter<?, ?> table;

    public PagesizeChooser(String id, DataTableWithPagesAndFilter<?, ?> table) {
        super(id);
        this.table = table;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    private void buildGui() {
        Button button = Wkt.add((MarkupContainer)this, new Button(ID_PAGESIZE_BUTTON));
        Wkt.labelAdd((MarkupContainer)button, ID_PAGESIZE_LABEL, this.table.getEntriesPerPageAsLiteral());
        Wkt.listViewAdd((MarkupContainer)this, ID_PAGESIZE_CHOICES, this.table.getPagesizeChoices(), (SerializableConsumer & Serializable)item -> {
            AjaxLinkNoPropagate link = Wkt.linkAdd((MarkupContainer)item, ID_PAGESIZE_CHOICE, (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)target -> {
                PagesizeChoice pagesizeChoice = (PagesizeChoice)item.getModelObject();
                this.table.setItemsPerPage(pagesizeChoice.itemsPerPage());
                this.table.setPageSizeHintAndBroadcast((AjaxRequestTarget)target);
                target.add(new Component[]{this.table});
            });
            PagesizeChooser.addIconAndTitle((ListItem<PagesizeChoice>)item, link);
            PagesizeChooser.addCheckmark((ListItem<PagesizeChoice>)item, link, this.table.getCurrentPagesizeChoice());
            Wkt.ajaxEnable(link);
        });
        WktTooltips.addTooltip(button, this.translate("How many rows to display per page"));
    }

    private String translate(String text) {
        return MetaModelContext.translationServiceOrFallback().translate(TranslationContext.named((String)"Table"), text);
    }

    private static void addIconAndTitle(@NonNull ListItem<PagesizeChoice> item, @NonNull AjaxLinkNoPropagate link) {
        WktLinks.listItemAsDropdownLink(item, link, ID_VIEW_ITEM_TITLE, pagesizeChoice -> Model.of((Serializable)((Object)pagesizeChoice.translatedTitle())), ID_VIEW_ITEM_ICON, null, null);
    }

    private static void addCheckmark(@NonNull ListItem<PagesizeChoice> item, @NonNull AjaxLinkNoPropagate link, @NonNull Optional<PagesizeChoice> currentPagesizeChoice) {
        Label checkmarkForChoice = Wkt.labelAdd((MarkupContainer)link, ID_VIEW_ITEM_CHECKMARK, "");
        Boolean isSelected = currentPagesizeChoice.map(currentChoice -> currentChoice.equals(item.getModelObject())).orElse(false);
        checkmarkForChoice.setVisible(isSelected.booleanValue());
        if (isSelected.booleanValue()) {
            link.setEnabled(false);
        }
    }

    @Generated
    public DataTableWithPagesAndFilter<?, ?> getTable() {
        return this.table;
    }
}

